package cn.yoofans.knowledge.center.api.dto.order;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 订单优惠券
 * Created by zhangshun on 2018/4/20,10:44:02.
 */
public class OrderCouponDto implements Serializable {

    private static final long serialVersionUID = 9046510728191438275L;

    /**
     * 优惠券ID
     */
    private String couponId;

    /**
     * 优惠券母版表主键ID
     */
    private Integer couponTemplateId;

    /**
     * 母版标题
     */
    private String couponTemplateTitle;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private Short couponConditionType;

    /**
     * 券面额(分)
     */
    private Integer couponPrice;

    /**
     * 使用范围类型，1:定向；2:通用
     */
    private Short couponUseScopeType;

    /**
     * 优惠券落地使用页面类型 1内容详情页 2:指定页面
     */
    private Short couponPageType;

    /**
     * 优惠券落地页ID,课程或专栏表ID或内容详情页ID
     */
    private Integer couponPageId;

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public Integer getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Integer couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getCouponTemplateTitle() {
        return couponTemplateTitle;
    }

    public void setCouponTemplateTitle(String couponTemplateTitle) {
        this.couponTemplateTitle = couponTemplateTitle;
    }

    public Short getCouponConditionType() {
        return couponConditionType;
    }

    public void setCouponConditionType(Short couponConditionType) {
        this.couponConditionType = couponConditionType;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Short getCouponUseScopeType() {
        return couponUseScopeType;
    }

    public void setCouponUseScopeType(Short couponUseScopeType) {
        this.couponUseScopeType = couponUseScopeType;
    }

    public Short getCouponPageType() {
        return couponPageType;
    }

    public void setCouponPageType(Short couponPageType) {
        this.couponPageType = couponPageType;
    }

    public Integer getCouponPageId() {
        return couponPageId;
    }

    public void setCouponPageId(Integer couponPageId) {
        this.couponPageId = couponPageId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
