package cn.yoofans.knowledge.center.api.dto.order;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Created by sunyan on 2018/4/12.
 */
public class OrderDetailDto implements Serializable {

    private static final long serialVersionUID = -6690866389323643971L;

    private OrderDto orderDto;

    private List<OrderItemDto> orderItemDtos;

    private List<OrderFundDto> orderFundDtos;

    public OrderDto getOrderDto() {
        return orderDto;
    }

    public void setOrderDto(OrderDto orderDto) {
        this.orderDto = orderDto;
    }

    public List<OrderItemDto> getOrderItemDtos() {
        return orderItemDtos;
    }

    public void setOrderItemDtos(List<OrderItemDto> orderItemDtos) {
        this.orderItemDtos = orderItemDtos;
    }

    public List<OrderFundDto> getOrderFundDtos() {
        return orderFundDtos;
    }

    public void setOrderFundDtos(List<OrderFundDto> orderFundDtos) {
        this.orderFundDtos = orderFundDtos;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        OrderDetailDto that = (OrderDetailDto) o;
        return Objects.equals(orderDto, that.orderDto) && Objects.equals(orderItemDtos, that.orderItemDtos) && Objects
            .equals(orderFundDtos, that.orderFundDtos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderDto, orderItemDtos, orderFundDtos);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
