package cn.yoofans.knowledge.center.api.dto.order;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class OrderFastDto implements Serializable {

    private static final long serialVersionUID = 4706563654829252949L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 业务类型:PAY=付款、REFUND=退款
     */
    private String bizType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        OrderFastDto dto = (OrderFastDto) o;
        return Objects.equals(id, dto.id) && Objects.equals(orderId, dto.orderId) && Objects
            .equals(bizType, dto.bizType) && Objects.equals(gmtCreate, dto.gmtCreate) && Objects
            .equals(gmtModified, dto.gmtModified);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, orderId, bizType, gmtCreate, gmtModified);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}