package cn.yoofans.knowledge.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by sunyan on 2018/4/13.
 */
public enum UserDistributionTypeEnum {
    /** 渠道分销 */
    CHANNEL("CHANNEL","c", "渠道分销"),

    /** 用户分销 */
    USER("USER","u", "用户分销");

    /** 代码 */
    private String code;

    /** 传播前缀 */
    private String start;

    /** 描述 */
    private String desc;

    UserDistributionTypeEnum(String code, String start,String desc) {
        this.code = code;
        this.start = start;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static UserDistributionTypeEnum getByCode(String code) {
        for (UserDistributionTypeEnum enumVal : UserDistributionTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public static UserDistributionTypeEnum getByStart(String start) {
        for (UserDistributionTypeEnum enumVal : UserDistributionTypeEnum.values()) {
            if (StringUtils.equals(start, enumVal.getStart())) {
                return enumVal;
            }
        }
        return null;
    }


    public String getCode() {
        return code;
    }

    public String getStart() {
        return start;
    }

    public String getDesc() {
        return desc;
    }
}
