package cn.yoofans.knowledge.center.api.enums.comment;

import java.util.Objects;

/**
 * Created by zhangshun on 2018/5/22,19:30:04.
 */
public enum CommentStateEnum {

    AUDIT(1, "待审核"),

    PASSED(2, "已通过"),

    HIDE(3, "已隐藏");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CommentStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static CommentStateEnum getByCode(Integer code) {
        for (CommentStateEnum value : CommentStateEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }
}
