package cn.yoofans.knowledge.center.api.enums.comment;

import java.util.Objects;

/**
 * Created by zhangshun on 2018/5/22,19:30:04.
 */
public enum CommentTypeEnum {

    READ(1, "阅读");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CommentTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static CommentTypeEnum getByCode(Integer code) {
        for (CommentTypeEnum value : CommentTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }
}
