package cn.yoofans.knowledge.center.api.enums.order;

import java.nio.charset.Charset;

import org.apache.commons.lang.StringUtils;

/**
 * Created by sunyan on 2018/4/11.
 */
public enum OrderStatusEnum {
    /**
     * 待付款
     */
    TO_PAY("TO_PAY", "待支付"),

    /**
     * 交易完成
     */
    SUCCESS("SUCCESS", "交易成功"),

    /**
     * 交易失败
     */
    FAILED("FAILED", "交易失败"),

    /**
     * 退款中
     */
    REFUNDING("REFUNDING", "退款中"),

    /**
     * 退款成功
     */
    REFUND_SUCCEED("REFUND_SUCCEED", "退款成功"),

    /**
     * 退款失败
     */
    REFUND_FAILED("REFUND_FAILED", "退款失败");

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    OrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static OrderStatusEnum getByCode(String code) {
        for (OrderStatusEnum enumVal : OrderStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return new String(desc.getBytes(), Charset.forName("UTF-8"));
    }
}
