package cn.yoofans.knowledge.center.api.param;

import java.util.Objects;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

/**
 * Created by zhangshun on 2018/5/22,13:45:53.
 */
public class PageParam implements java.io.Serializable {

    /**
     * 页码，默认页码为1
     */
    private Integer pageNum = 1;

    /**
     * 分页大小，默认分页大小为20
     */
    private Integer pageSize = 20;

    private Integer startIndex;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setStartIndex(Integer pageNum, Integer pageSize) {
        if (Objects.isNull(pageNum) || 0 == pageNum.intValue()) {
            this.startIndex = 0;
        }
        if (Objects.isNull(pageSize) || 0 == pageSize.intValue()) {
            this.startIndex = 0;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        this.startIndex = (pageNum - 1) * pageSize;
    }

    public Integer getStartIndex() {
        if (Objects.isNull(pageNum) || 0 == pageNum.intValue()) {
            this.startIndex = 0;
        }
        if (Objects.isNull(pageSize) || 0 == pageSize.intValue()) {
            this.startIndex = 0;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        return this.startIndex = (pageNum - 1) * pageSize;
    }

    public Pageable getPageable() {
        return new PageRequest(pageNum - 1, pageSize);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
