/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteAuthorizeMpTemplate
 * Author:   amu
 * Date:     2018/5/10 上午10:38
 * Description: 公众号模板
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.AuthorizeMpTemplateDTO;
import cn.yoofans.knowledge.center.api.dto.template.MsgDTO;
import cn.yoofans.knowledge.center.api.enums.AuthorizerMpTemplateTypeEnum;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈公众号模板〉
 *
 * @author amu
 * @create 2018/5/10
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteAuthorizeMpTemplateService {

    /**
     * 添加/修改
     * @param authorizeMpTemplateDTO
     * @return 成功/失败
     */
    Boolean saveAuthorizeMpTemplate(AuthorizeMpTemplateDTO authorizeMpTemplateDTO);

    /**
     * 根据公众号获取模板
     * @param authorizerId 公众号ID
     * @return 模板集合
     */
    List<AuthorizeMpTemplateDTO> findByAuthorizerId(Long authorizerId);

    /**
     * 按照id查询
     * @param id
     * @return
     */
    AuthorizeMpTemplateDTO findById(Long id);

    /**
     * 发送模板消息
     * @param toConsumerId 接收者
     * @param authorizerId  授权账号Id
     * @param msgDTO 消息内容
     * @param typeEnum 模板类型
     */
    void sendAuthorizeMpTemplateMessage(Long toConsumerId, Long authorizerId, MsgDTO msgDTO, AuthorizerMpTemplateTypeEnum typeEnum);

    /**
     * 按照公众号id与模板类型查询
     * @param authorizerId
     * @param templateType
     * @return
     */
    AuthorizeMpTemplateDTO findByAuthorizerIdAndTemplateType( Long authorizerId,Integer templateType);
}
