package cn.yoofans.knowledge.center.api.enums.account;

/**
 * 账户资金流水操作类型枚举类
 */
public enum OperateTypeEnum {

    EXPENDITURE(1, "支出"),

    INCOME(2, "收入");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    OperateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的课程类型
     *
     * @param code
     * @return
     */
    public static OperateTypeEnum getByCode(Integer code) {
        for (OperateTypeEnum status : OperateTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    public Integer getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
