package cn.yoofans.knowledge.center.api.enums.page;

/**
 * 皮肤类型枚举
 * @author zhanghuifeng
 * @date 2018/7/5上午11:56
 */
public enum SkinTypeEnum {

    DETAIL_PAGE(1, "计划详情页"),
    UNITED_DETAIL_PAGE(2, "聚合计划详情页");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    SkinTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static SkinTypeEnum getByCode(Integer code) {
        for (SkinTypeEnum status : SkinTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
