package cn.yoofans.knowledge.center.api.param.coupon;

import cn.yoofans.knowledge.center.api.enums.coupon.*;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 优惠券母版参数
 * @author zhanghuifeng
 * @date 2018/4/23下午5:47
 */
public class CouponTemplateParams implements Serializable {

    private static final long serialVersionUID = -8404632338417581978L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 优惠券母版ID
     */
    private String couponTemplateId;

    /**
     * 母版标题
     */
    private String title;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private Integer conditionType;

    /**
     * 使用条件：当为满减时，为金额（分
     * {@link CouponTemplateConditionTypeEnum}
     */
    private Integer conditionValue;


    /**
     * 券面额（分）
     */
    private Integer couponPrice;

    /**
     * 优惠券开始日期
     */
    private Date couponStartTime;

    /**
     * 优惠券结束日期
     */
    private Date couponEndTime;


    /**
     * 使用范围，1:定向；2:通用
     * {@link CouponUseScopeTypeEnum}
     */
    private Integer useScopeType;

    /**
     * 优惠券母版和指定商品关联信息列表
     */
    private List<CouponTemplateItemParams> couponTemplateGoodsList;

    /**
     * 落地使用页面类型 1内容详情页 2:指定页面
     * {@link CouponPageTypeEnum}
     */
    private Integer pageType;

    /**
     * 当落地使用页面类型为指定页面时，落地使用页面商品类型，1 单课 2 专栏
     * {@link CouponPageItemTypeEnum}
     */
    private Integer pageItemType;

    /**
     * 落地使用页面课程或专栏表主键ID或内容详情页ID
     */
    private Long pageLocationId;

    /**
     * 有效期类型 1领券起天数；2固定周期
     * {@link CouponValidTypeEnum}
     */
    private Integer validityType;

    /**
     * 领券起天数
     */
    private Integer validityDays;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getConditionType() {
        return conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public Integer getConditionValue() {
        return conditionValue;
    }

    public void setConditionValue(Integer conditionValue) {
        this.conditionValue = conditionValue;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Date getCouponStartTime() {
        return couponStartTime;
    }

    public void setCouponStartTime(Date couponStartTime) {
        this.couponStartTime = couponStartTime;
    }

    public Date getCouponEndTime() {
        return couponEndTime;
    }

    public void setCouponEndTime(Date couponEndTime) {
        this.couponEndTime = couponEndTime;
    }

    public List<CouponTemplateItemParams> getCouponTemplateGoodsList() {
        return couponTemplateGoodsList;
    }

    public void setCouponTemplateGoodsList(List<CouponTemplateItemParams> couponTemplateGoodsList) {
        this.couponTemplateGoodsList = couponTemplateGoodsList;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public Long getPageLocationId() {
        return pageLocationId;
    }

    public void setPageLocationId(Long pageLocationId) {
        this.pageLocationId = pageLocationId;
    }

    public Integer getPageItemType() {
        return pageItemType;
    }

    public void setPageItemType(Integer pageItemType) {
        this.pageItemType = pageItemType;
    }

    public Integer getUseScopeType() {
        return useScopeType;
    }

    public void setUseScopeType(Integer useScopeType) {
        this.useScopeType = useScopeType;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public Integer getValidityDays() {
        return validityDays;
    }

    public void setValidityDays(Integer validityDays) {
        this.validityDays = validityDays;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
