package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.order.OrderDetailDto;
import cn.yoofans.knowledge.center.api.dto.order.OrderDto;
import cn.yoofans.knowledge.center.api.enums.refund.OrderDistributionTypeEnum;
import cn.yoofans.knowledge.center.api.param.order.CreateOrderParam;
import cn.yoofans.knowledge.center.api.param.order.OrderPageParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * Created by sunyan on 2018/4/11.
 */
@AdvancedFeignClient
public interface RemoteOrderService {

    /**
     * 创建订单
     *
     * @param createOrderParam
     * @return
     */
    OrderDto createOrder(CreateOrderParam createOrderParam);

    /**
     * 订单查询
     *
     * @param orderId
     * @return
     */
    OrderDto getByOrderId(String orderId);

    /**
     * 分页查询
     *
     * @param orderPageParam
     * @return
     */
    PageImpl<OrderDto> findByPage(OrderPageParam orderPageParam);

    /**
     * 订单详情
     *
     * @param orderId
     * @return
     */
    OrderDetailDto findDetail(String orderId);

    /**
     * 导出数据
     *
     * @param orderPageParam
     * @return
     */
    List<OrderDto> export(OrderPageParam orderPageParam);

    /**
     * 获取订单信息
     *
     * @param orderIds
     * @return
     */
    List<OrderDto> findListByOrderIds(List<String> orderIds) throws BizException;

    /**
     * 获取订单分销类型
     *
     * @param orderId
     * @return
     */
    OrderDistributionTypeEnum getOrderDistributionType(String orderId);

    /**
     * 手机端-我的订单列表（交易成功|退款中|退款成功（退款成功|强制退款成功）状态的订单）
     * @param userId
     * @return
     */
    List<OrderDto> findShowOrderListByUserId(Long userId);
}
