package cn.yoofans.knowledge.center.api.dto.coupon;

import java.io.Serializable;
import java.util.Date;

/**
 * 优惠券信息分页dto
 *
 * @author zhanghuifeng
 * @date 2018/4/25下午4:30
 */
public class CouponInfoPageDto implements Serializable {
    private static final long serialVersionUID = -8567398818316816972L;

    /**
     * id
     */
    private Long id;

    /**
     * 母版id
     */
    private Long templateId;

    /**
     * 母版标题
     */
    private String couponTemplateTitle;

    /**
     * 优惠券ID
     */
    private String couponId;

    /**
     * 券面额（分）
     */
    private Integer couponPrice;

    /**
     * 优惠券开始日期
     */
    private Date couponStartTime;

    /**
     * 优惠券结束日期
     */
    private Date couponEndTime;


    /**
     * 券状态，-1:已过期；0:待使用；1:已使用
     */
    private Integer couponStatus;

    /**
     * 优惠券母版ID
     */
    private String couponTemplateId;

    /**
     * 创建时间=领取时间，后期有可能变动
     */
    private Date gmtCreate;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 使用时间
     */
    private Date usedTime;

    /**
     * 来源类型
     */
    private Integer sourceType;

    /**
     * 来源id
     */
    private String sourceId;

    public String getCouponTemplateTitle() {
        return couponTemplateTitle;
    }

    public void setCouponTemplateTitle(String couponTemplateTitle) {
        this.couponTemplateTitle = couponTemplateTitle;
    }

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Date getCouponStartTime() {
        return couponStartTime;
    }

    public void setCouponStartTime(Date couponStartTime) {
        this.couponStartTime = couponStartTime;
    }

    public Date getCouponEndTime() {
        return couponEndTime;
    }

    public void setCouponEndTime(Date couponEndTime) {
        this.couponEndTime = couponEndTime;
    }

    public Integer getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(Integer couponStatus) {
        this.couponStatus = couponStatus;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
}
