package cn.yoofans.knowledge.center.api.enums.card;

/**
 * 专栏枚举类
 */
public enum UserCardStatusEnum {

    WAIT_DRAW(1, "待领取"),

    DRAWED(2, "已领取"),

    ACTIVED(3, "已激活"),

    EXPIRED(4, "已失效"),

    REFUNDING(5, "退款中"),

    REFUNDED(6,"已退款");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    UserCardStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static UserCardStatusEnum getByCode(Integer code) {
        for (UserCardStatusEnum status : UserCardStatusEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
