package cn.yoofans.knowledge.center.api.enums.test;

import java.util.Objects;

/**
 * 测试计划业务类型枚举
 * Created by qiuyp
 */
public enum PlanBussinessTypeEnum {

    READ(1, "一修读书");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    PlanBussinessTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static PlanBussinessTypeEnum getByCode(Integer code) {
        for (PlanBussinessTypeEnum value : PlanBussinessTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
