package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.enums.msg.ValidCodeCheckResult;
import cn.yoofans.knowledge.center.api.enums.msg.ValidCodeSendResult;

/**
 * @Author danke
 * @Date :Create in 下午5:55 2018/8/20
 * 短信服务remote接口
 */
@AdvancedFeignClient
public interface RemoteMsgService {

    /**
     * 发送验证码
     */
    ValidCodeSendResult sendValidCode(String phone);

    /**
     * 校验验证码
     */
    ValidCodeCheckResult validCodeCheck(String phone, String validCode);

    /**
     * 是否需要弹图形验证码
     * true-需要 false-不需要
     * @param phone
     * @return
     * 如果获取次数 >= threshold 则认为true
     */
    Integer sendCodeNum(String phone);

}
