package cn.yoofans.knowledge.center.api.remoteservice.course;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.course.CourseHandoutDTO;

import java.util.List;

/**
 * 课程讲义远程调用接口
 */
@AdvancedFeignClient
public interface RemoteCourseHandoutService {
    /**
     * 批量新增数据
     *
     * @param handoutList
     * @return
     */
    Boolean save(Long courseId, List<CourseHandoutDTO> handoutList);

    /**
     * 依据courseId删除数据
     *
     * @param courseId
     * @return
     */
    Boolean deleteByCourseId(Long courseId);

    /**
     * 依据courseId查询数据列表
     *
     * @param courseId
     * @return
     */
    List<CourseHandoutDTO> selectListByCourseId(Long courseId);
}
