/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ReadBookCourse
 * Author:   amu
 * Date:     2018/5/23 上午9:59
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.Date;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadBookCourseDTO;

/**
 * 〈一句话功能简述〉<br>
 * 〈〉
 *
 * @author amu
 * @create 2018/5/23
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteReadBookCourseService {

    /**
     * 修改/保存
     *
     * @param readBookCourseDTO
     * @return
     */
    int save(ReadBookCourseDTO readBookCourseDTO);

    /**
     * 修改/保存
     *
     * @param readBookCourseDTO
     * @return
     */
    int edit(ReadBookCourseDTO readBookCourseDTO);

    /**
     * 按照id查询
     *
     * @param id
     * @return
     */
    ReadBookCourseDTO findById(Long id);

    /**
     * 按照readId查询
     *
     * @param readId
     * @return
     */
    List<ReadBookCourseDTO> findListByReadId(Long readId);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 按照bookId查询
     *
     * @param bookId
     * @return
     */
    List<ReadBookCourseDTO> findByBookIdAndReadId(Long bookId, Long readId);

    /**
     * 根据阅读ID和课程id查询日期
     *
     * @param readId
     * @param courseId
     * @return
     */
    Date getReadDateByCourse(Long readId, Long courseId, Date beginDate);

    /**
     * 按照阅读id和课程id查询
     *
     * @param readId
     * @param courseId
     * @return
     */
    ReadBookCourseDTO findByReadIdAndCourseId(Long readId, Long courseId);

    /**
     * 根据阅读ID,第几天查询
     *
     * @param readId
     * @param day
     * @return
     */
    ReadBookCourseDTO getByReadIdDay(Long readId, Integer day);
}
