package cn.yoofans.knowledge.center.api.dto.coupon;

import cn.yoofans.knowledge.center.api.enums.coupon.CouponBatchGrantOperateStateEnum;

import java.io.Serializable;

/**
 * 优惠券批量生产批次
 * @author zhanghuifeng
 * @date 2018/8/9下午7:11
 */
public class CouponBatchGrantDto implements Serializable {
    private static final long serialVersionUID = 6979483453157600118L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 优惠券母版ID
     */
    private String couponTemplateId;

    /**
     * 发券数量
     */
    private Integer grantCount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作状态
     * @see CouponBatchGrantOperateStateEnum
     */
    private Integer operateState;

    /**
     * 下载链接
     */
    private String downloadUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Integer getGrantCount() {
        return grantCount;
    }

    public void setGrantCount(Integer grantCount) {
        this.grantCount = grantCount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getOperateState() {
        return operateState;
    }

    public void setOperateState(Integer operateState) {
        this.operateState = operateState;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}
