/**
 * Project Name:qiho-center-api
 * File Name:FundBizTypeEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年7月18日下午4:48:11
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.yoofans.knowledge.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:FundBizTypeEnum <br/>
 * 资金业务类型枚举. <br/>
 * Created by sunyan on 2018/4/11.
 */
public enum FundBizTypeEnum {
    /** 付款 */
    PAY("PAY", "付款"),
    
    /** 退款 */
    REFUND("REFUND", "退款");
    
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private FundBizTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static FundBizTypeEnum getByCode(String code) {
        for (FundBizTypeEnum enumVal : FundBizTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

