package cn.yoofans.knowledge.center.api.enums;

/**
 * 海报商品类型标识枚举类
 */
public enum PosterItemTypeEnum {

    PUBLIC(0, "公共海报"),

    COURSE(1, "课程海报"),

    COLUMN(2, "专栏海报"),

    READ_PLAN(3, "阅读计划海报");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    PosterItemTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的海报商品类型
     *
     * @param code
     * @return
     */
    public static PosterItemTypeEnum getByCode(Integer code) {
        for (PosterItemTypeEnum status : PosterItemTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
