package cn.yoofans.knowledge.center.api.enums.playprogress;

import java.util.Objects;

/**
 * @author zhanghuifeng
 * @date 2018/9/3下午2:05
 */
public enum UserPlaybackProgressClockStateEnum {

    UN_CLOCK(0, "未打卡"),
    CLOCK(1, "已打卡");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    UserPlaybackProgressClockStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static UserPlaybackProgressClockStateEnum getByCode(Integer code) {
        for (UserPlaybackProgressClockStateEnum value : UserPlaybackProgressClockStateEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }
}
