/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: AnswerStateEnum
 * Author:   amu
 * Date:     2018/9/12 下午5:56
 * Description: 用户回答结果的状态
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.enums.question;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 〈一句话功能简述〉<br> 
 * 〈用户回答结果的状态〉
 *
 * @author amu
 * @create 2018/9/12
 * @since 1.0.0
 */
public enum AnswerStateEnum {

    NON_RIGHT(0, "一个没对"), PART_RIGHT(1, "答对一部分"), ALL_RIGHT(2, "全对");

    private Integer code;

    private String desc;

    AnswerStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Integer, AnswerStateEnum> typeMap = Maps.newHashMap();

    static {
        for (AnswerStateEnum readStateEnum : AnswerStateEnum.values()) {
            typeMap.put(readStateEnum.getCode(), readStateEnum);
        }
    }

    public static AnswerStateEnum getByCode(Integer code) {
        return typeMap.get(code);
    }
}
