/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: FinishQuestionStateEnum
 * Author:   amu
 * Date:     2018/9/13 上午11:55
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.enums.question;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 〈一句话功能简述〉<br>
 * 〈〉
 *
 * @author amu
 * @create 2018/9/13
 * @since 1.0.0
 */
public enum FinishQuestionStateEnum {

    FINISH_QUESTION(1,"完题"),

    NOT_FINISH_QUESTION(0,"未完题");

    private Integer code;

    private String desc;

    FinishQuestionStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Integer, FinishQuestionStateEnum> typeMap = Maps.newHashMap();

    static {
        for (FinishQuestionStateEnum readStateEnum : FinishQuestionStateEnum.values()) {
            typeMap.put(readStateEnum.getCode(), readStateEnum);
        }
    }

    public static FinishQuestionStateEnum getByCode(Integer code) {
        return typeMap.get(code);
    }
    }
