package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.order.OrderFundDto;
import cn.yoofans.knowledge.center.api.enums.FundBizTypeEnum;

import java.util.List;

/**
 * 订单资金流水远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteOrderFundService {
    /**
     * @param orderId
     * @param bizType {@link FundBizTypeEnum}
     * @return
     */
    OrderFundDto findByOrderIdAndBizType(String orderId, String bizType);

    /**
     * 依据订单id查询
     *
     * @param orderId
     * @return
     */
    List<OrderFundDto> findByOrderId(String orderId);
}
