package cn.yoofans.knowledge.center.api.remoteservice.card;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.card.UserCardDto;
import cn.yoofans.knowledge.center.api.param.card.UserCardPageParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

@AdvancedFeignClient
public interface RemoteUserCardService {

    Boolean deleteById(Long id);

    Long save(UserCardDto entity);

    UserCardDto selectById(Long id);

    /**
     * 分页查询
     */

    PageImpl<UserCardDto> pageByQuery(UserCardPageParam pageParam);

    List<UserCardDto> selectByUserId(Long userId);

    List<UserCardDto> selectByPhone(Long phone,Integer userCardState);


    /**
     * 按照卡券唯一标识查询
     * @param cardTicketId
     * @return
     */
    UserCardDto selectByCardTicketId(String cardTicketId);

    /**
     * 通过订单id查询
     * 这边一笔订单应该只对应一张卡
     */
    UserCardDto selectByOrderId(String orderId);

    /**
     * 激活用户礼品卡
     * @param cardDto
     * @return 激活后的礼品卡状态
     */
    UserCardDto activeUserCard(UserCardDto cardDto) throws BizException;

    /**
     *用户领取卡券
     */
    UserCardDto drawUserCard(UserCardDto cardDto) throws BizException;


}