package cn.yoofans.knowledge.center.api.remoteservice.comment;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.comment.CommentDto;
import cn.yoofans.knowledge.center.api.param.comment.CommentSearchParam;

/**
 * Created by zhangshun on 2018/5/24,13:37:09.
 */
@AdvancedFeignClient
public interface RemoteCommentService {

    /**
     * 修改观点
     */
    boolean updateById(CommentDto commentDto);

    /**
     * 修改业务数据
     */
    boolean updateBiz(CommentSearchParam param);

    /**
     * 修改状态
     *
     * @param commentIds
     * @param status
     * @return
     */
    boolean changeStatus(String commentIds, Integer status);

    /**
     * 修改权重值
     *
     * @param commentId
     * @param sorted
     * @return
     */
    boolean changeSorted(Long commentId, Integer sorted);

    /**
     * 根据ID查询
     *
     * @param commentId
     * @return
     */
    CommentDto getById(Long commentId);

    /**
     * 根据用户ID,阅读ID,课程ID查询
     *
     * @param userId
     * @param readId
     * @param courseId
     * @return
     */
    CommentDto getByUserReadCourse(Long userId, Long readId, Long courseId);

    /**
     * 分页查询个数
     *
     * @param param
     * @return
     */
    Long countByPage(CommentSearchParam param);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<CommentDto> findByPage(CommentSearchParam param);

    /**
     * 通过用户id,阅读计划id,阅读计划期数id,查询出用户所有感想
     * @param userId
     * @param readId
     * @param readStageId
     * @return
     */
    List<CommentDto> findByUserAndReadAndReadStage(Long userId,Long readId,Long readStageId);

    /**
     * 修复
     * @param readId
     * @param courseId
     * @param startTime
     * @param endTime
     * @param id
     * @param finishStatus
     * @return
     */
    Boolean fixUserFinishStatus(Long readId,Long courseId,String startTime,String endTime,Long id,Integer finishStatus);

}
