package cn.yoofans.knowledge.center.api.remoteservice.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.page.ItemDetailPageDto;
import cn.yoofans.knowledge.center.api.param.page.ItemDetailPageQryParams;
import org.springframework.data.domain.PageImpl;

/**
 * 产品详情页信息服务
 * @author zhanghuifeng
 * @date 2018/7/5下午2:39
 */
@AdvancedFeignClient
public interface RemoteItemDetailPageService {

    /**
     * 根据主键ID查询
     * @param id 主键ID
     * @return 信息
     */
    ItemDetailPageDto findById(Long id);

    /**
     * 更新隐藏状态
     * @param id    详情页主键ID
     * @param isHide 隐藏状态
     * @return
     */
    Boolean updateIsHide(Long id, Integer isHide);

    /**
     * 插入
     * @param dto
     * @return
     */
    Boolean insert(ItemDetailPageDto dto);

    /**
     * 更新
     * @param dto
     * @return
     */
    Boolean update(ItemDetailPageDto dto);


    /**
     * 分页查询数据
     *
     * @param pageQryParam
     * @return
     */
    PageImpl<ItemDetailPageDto> findPageList(ItemDetailPageQryParams pageQryParam);

    /**
     * 设置默认详情页
     * @param itemId    产品ID
     * @param itemType  产品类型 {@link cn.yoofans.knowledge.center.api.enums.page.ItemTypeEnum}
     * @param defaultDetailPageId 详情页ID
     * @return boolean
     */
    Boolean setDefault(Long itemId, Integer itemType, Long defaultDetailPageId);

    /**
     * 获取默认详情页
     * @param itemId
     * @param itemType
     * @return
     */
    ItemDetailPageDto findDefault(Long itemId, Integer itemType);

    /**
     * 查询存在的最大值的详情页
     * 更具itemType
     */
    ItemDetailPageDto findMaxIdDetailByType(Integer itemType);

    /**
     * 通过阅读计划id查询出按照id倒叙的阅读计划详情
     */
    ItemDetailPageDto findMaxIdDetailBRyReadId(Long readId,Integer itemType);
}
