package cn.yoofans.knowledge.center.api.remoteservice.question;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.question.QuestionDTO;
import cn.yoofans.knowledge.center.api.dto.question.QuestionSubmitResultDTO;
import cn.yoofans.knowledge.center.api.param.question.QuestionParams;
import cn.yoofans.knowledge.center.api.param.question.SubmitAnswerParams;

import org.springframework.data.domain.PageImpl;

/**
 * @author zhangmm
 * @Description: 问题rpc
 * @date 2018/9/10 001017:07
 */
@AdvancedFeignClient
public interface RemoteQuestionService {

    /**
     * 删除问题
     *
     * @param id ID
     * @return 信息
     */
    int delete(Long id);

    /**
     * 新增问题
     *
     * @param dto 参数
     * @return boolean
     */
    Boolean add(QuestionDTO dto);

    /**
     * 更新问题
     *
     * @param dto
     * @return
     */
    Boolean update(QuestionDTO dto);

    /**
     * 问题管理分页查询
     *
     * @param qryParams
     * @return
     */
    PageImpl<QuestionDTO> ListForPage(QuestionParams qryParams);

    /**
     * 按照课程 阅读计划id查询题库
     *
     * @param courseId
     * @return
     */
    List<QuestionDTO> findByCourseId(Long courseId, Long readId);

    /**
     * 按照id查询
     *
     * @param id
     * @return
     */
    QuestionDTO findById(Long id);

    /**
     * 用户提交答案
     *
     * @return
     */
    QuestionSubmitResultDTO submitAnswer(SubmitAnswerParams submitAnswerParams) throws BizException;

}
