/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteReadBookService
 * Author:   amu
 * Date:     2018/5/22 下午8:38
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadBookDTO;

/**
 * 〈一句话功能简述〉<br>
 * 〈阅读计划书籍远程服务〉
 *
 * @author amu
 * @create 2018/5/22
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteReadBookService {

    /**
     * 添加 / 修改
     *
     * @param readBookDTO
     * @return
     */
    int save(ReadBookDTO readBookDTO);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 详情
     *
     * @param id
     * @return
     */
    ReadBookDTO findById(Long id);

    /**
     * 按照阅读id查询
     *
     * @param readId
     * @return
     */
    List<ReadBookDTO> findByReadId(Long readId);

    /**
     * 复制阅读计划的书籍和课程
     *
     * @param readIdOld
     * @param readIdNew
     * @return
     */
    boolean copyReadBook(Long readIdOld, Long readIdNew);
}
