package cn.yoofans.knowledge.center.api.remoteservice.sns;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.sns.SnsFileSyncDTO;
import cn.yoofans.knowledge.center.api.param.sns.SnsFileSyncPageQryParams;
import cn.yoofans.knowledge.center.api.param.sns.SnsSyncParams;
import org.springframework.data.domain.PageImpl;

@AdvancedFeignClient
public interface RemoteSnsFileSyncService {

    /**
     * 保存数据
     *
     * @param snsFileSync
     * @return
     */
    Boolean insert(SnsFileSyncDTO snsFileSync);

    /**
     * 依据Id删除数据
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 修改
     *
     * @param snsFileSync
     * @return
     */
    Boolean update(SnsFileSyncDTO snsFileSync);

    /**
     * 依据主键id查询数据
     *
     * @param id
     * @return
     */
    SnsFileSyncDTO findOneById(Long id);

    /**
     * 依据recordId查询数据
     *
     * @param recordId
     * @return
     */
    SnsFileSyncDTO findOneByRecordId(Long recordId);

    /**
     * 执行文件数据同步
     *
     * @param param
     * @return
     */
    Boolean doSnsFileSync(SnsSyncParams param) throws BizException;

    /**
     * 分页查询数据
     *
     * @param queryParams
     * @return
     */
    PageImpl<SnsFileSyncDTO> findPageList(SnsFileSyncPageQryParams queryParams);

}
