/*
 * Decompiled with CFR 0.152.
 */
package com.abchina.openbank;

import com.abchina.openbank.encrypt.AESCrypt;
import com.abchina.openbank.encrypt.Crypt;
import com.abchina.openbank.encrypt.SM4Crypt;
import com.abchina.openbank.sign.RawSignService;
import com.abchina.openbank.sign.SM2SignService;
import com.abchina.openbank.sign.SignService;

public class OpenBankHttpClient {
    private static OpenBankHttpClient client = null;
    private static String appId;
    private static SignService signService;
    private static Crypt crypt;

    private OpenBankHttpClient() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initOpenBankHttpClient(String ... args) throws Exception {
        int n = args.length;
        String appId1 = args[0];
        String pfxFile = args[1];
        String pfxPwd = args[2];
        String certFile = args[3];
        String appSecret = args[4];
        if (n == 6) {
            String isSM4withSM2 = args[5];
            if ("1".equals(isSM4withSM2)) {
                signService = new SM2SignService(pfxFile, pfxPwd, certFile);
                crypt = new SM4Crypt(appSecret);
            } else {
                if (!"0".equals(isSM4withSM2)) throw new Exception("initOpenBankHttpClient \u7b7e\u540d\u7b97\u6cd5\u53c2\u6570\u9519\u8bef");
                signService = new RawSignService(pfxFile, pfxPwd, certFile);
                crypt = new AESCrypt(appSecret);
            }
        } else {
            signService = new RawSignService(pfxFile, pfxPwd, certFile);
            crypt = new AESCrypt(appSecret);
        }
        appId = appId1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenBankHttpClient getInstance() {
        if (client != null) return client;
        Class<OpenBankHttpClient> var0 = OpenBankHttpClient.class;
        Class<OpenBankHttpClient> var1 = OpenBankHttpClient.class;
        Class<OpenBankHttpClient> clazz = OpenBankHttpClient.class;
        synchronized (OpenBankHttpClient.class) {
            if (client != null) return client;
            client = new OpenBankHttpClient();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return client;
        }
    }

    public String getAppId() {
        return appId;
    }

    public SignService getSignService() {
        return signService;
    }

    public Crypt getCrypt() {
        return crypt;
    }

    public String getVersion() {
        return "V1.0";
    }
}

