/*
 * Decompiled with CFR 0.152.
 */
package com.abchina.openbank.encrypt;

import com.abchina.openbank.encrypt.Crypt;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Crypt
implements Crypt {
    private static final String ENCODING = "UTF-8";
    private static final String ALGORIGTHM_NAME = "SM4";
    private static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS7Padding";
    private static final int DEFAULT_KEY_SIZE = 128;
    private String appSecret;

    public SM4Crypt() {
    }

    public SM4Crypt(String appSecret) {
        this.appSecret = appSecret;
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORIGTHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static byte[] generateKey() throws Exception {
        return SM4Crypt.generateKey(128);
    }

    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORIGTHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    @Override
    public String enCrypt(String data, String charset) {
        String cipherText = "";
        if (null != data && !"".equals(data)) {
            byte[] keyData = Base64.decodeBase64(this.appSecret);
            if ((charset = charset.trim()).length() <= 0) {
                charset = ENCODING;
            }
            try {
                byte[] srcData = data.getBytes(charset);
                byte[] cipherArray = SM4Crypt.encrypt_Ecb_Padding(keyData, srcData);
                cipherText = Base64.encodeBase64String(cipherArray);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cipherText;
    }

    private static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = SM4Crypt.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        byte[] bs = cipher.doFinal(data);
        return bs;
    }

    @Override
    public String deCrypt(String cipherText, String charset) {
        String key = this.appSecret;
        String decryptStr = "";
        cipherText = cipherText.replace("\\r\\n", "");
        try {
            charset = charset.trim();
            if (charset.length() <= 0) {
                charset = ENCODING;
            }
            byte[] keyData = Base64.decodeBase64(key.getBytes(charset));
            byte[] cipherData = Base64.decodeBase64(cipherText.getBytes(charset));
            byte[] srcData = SM4Crypt.decrypt_Ecb_Padding(keyData, cipherData);
            decryptStr = new String(srcData, charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptStr;
    }

    private static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = SM4Crypt.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String key, String cipherText, String paramStr) throws Exception {
        boolean flag = false;
        byte[] keyData = Base64.decodeBase64(key);
        byte[] cipherData = Base64.decodeBase64(cipherText);
        byte[] decryptData = SM4Crypt.decrypt_Ecb_Padding(keyData, cipherData);
        byte[] srcData = paramStr.getBytes(ENCODING);
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }

    public static void main(String[] args) {
        try {
            String json = "{\"name\":\"color\",\"sex\":\"man\"}";
            String key = "x99h1Sy1Q1KFp+XOC3+FUQ==";
            SM4Crypt sm4Crypt1 = new SM4Crypt(key);
            String cipher = sm4Crypt1.enCrypt(json, ENCODING);
            System.out.println(cipher);
            System.out.println(SM4Crypt.verifyEcb(key, cipher, json));
            SM4Crypt sm4Crypt2 = new SM4Crypt(key);
            cipher = "CQaf3s4qhN5QFNX8hksWejmH1LhrFeA7ndU2ugWSsiGNULku9M088bIzIYUgmFo5+naHn31FVEVeUGRb5gAePAfd2GBRDbnK1N46gRVcyRBfhz3bEtQqI5T7Er3Lm5hHwCoQNLLFBKeLwW8bostmpJaetQJb+HGcqoUF8aLJCQwIHSNchBOAaTZIrmtLbql0r3y8EtW0bsCySrTK5SQ6zHhUDTctm0kiwwZ9ajMqsSM=";
            json = sm4Crypt2.deCrypt(cipher, ENCODING);
            System.out.println(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

