/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.portunif;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyIOEventProcessingHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.portunif.BackChannelFilter;
import org.glassfish.grizzly.portunif.PUContext;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.portunif.ProtocolFinder;
import org.glassfish.grizzly.utils.ArraySet;

public class PUFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(PUFilter.class);
    private final BackChannelFilter backChannelFilter = new BackChannelFilter(this);
    private final ArraySet<PUProtocol> protocols = new ArraySet<PUProtocol>(PUProtocol.class);
    final Attribute<PUContext> puContextAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(PUFilter.class.getName() + '-' + this.hashCode() + ".puContext");
    final Attribute<NextAction> terminateNextActionAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(PUFilter.class.getName() + '-' + this.hashCode() + ".terminateNextActionAttribute");
    final Attribute<FilterChainContext> suspendedContextAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(PUFilter.class.getName() + '-' + this.hashCode() + ".suspendedContext");

    public PUProtocol register(ProtocolFinder protocolFinder, FilterChain filterChain) {
        PUProtocol puProtocol = new PUProtocol(protocolFinder, filterChain);
        this.register(puProtocol);
        return puProtocol;
    }

    public void register(PUProtocol puProtocol) {
        Filter filter = (Filter)puProtocol.getFilterChain().get(0);
        if (filter != this.backChannelFilter) {
            throw new IllegalStateException("The first Filter in the protocol should be the BackChannelFilter");
        }
        this.protocols.add(puProtocol);
    }

    public void deregister(PUProtocol puProtocol) {
        this.protocols.remove(puProtocol);
    }

    public Set<PUProtocol> getProtocols() {
        return this.protocols;
    }

    public Filter getBackChannelFilter() {
        return this.backChannelFilter;
    }

    public FilterChainBuilder getPUFilterChainBuilder() {
        FilterChainBuilder builder = FilterChainBuilder.stateless();
        builder.add(this.backChannelFilter);
        return builder;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        NextAction terminateNextAction = this.terminateNextActionAttribute.remove(ctx);
        if (terminateNextAction != null) {
            return terminateNextAction;
        }
        Connection connection = ctx.getConnection();
        PUContext puContext = this.puContextAttribute.get(connection);
        if (puContext == null) {
            puContext = new PUContext(this);
            this.puContextAttribute.set(connection, puContext);
        } else if (puContext.noProtocolsFound()) {
            return ctx.getInvokeAction();
        }
        PUProtocol protocol = puContext.protocol;
        if (protocol == null) {
            this.findProtocol(puContext, ctx);
            protocol = puContext.protocol;
        }
        if (protocol != null) {
            if (!puContext.isSticky) {
                puContext.reset();
            }
            this.terminateNextActionAttribute.set(ctx, ctx.getStopAction());
            FilterChain filterChain = protocol.getFilterChain();
            FilterChainContext filterChainContext = filterChain.obtainFilterChainContext(connection);
            Context context = filterChainContext.getInternalContext();
            context.setIoEvent(IOEvent.READ);
            context.setProcessingHandler(new InternalProcessingHandler(ctx));
            filterChainContext.setAddress(ctx.getAddress());
            filterChainContext.setMessage(ctx.getMessage());
            this.suspendedContextAttribute.set(context, ctx);
            ProcessorExecutor.execute(context);
            return ctx.getSuspendAction();
        }
        if (puContext.noProtocolsFound()) {
            return ctx.getInvokeAction();
        }
        return ctx.getStopAction(ctx.getMessage());
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        PUProtocol protocol;
        Connection connection;
        PUContext puContext;
        if (PUFilter.isUpstream(ctx) && (puContext = this.puContextAttribute.get(connection = ctx.getConnection())) != null && (protocol = puContext.protocol) != null) {
            this.terminateNextActionAttribute.set(ctx, ctx.getStopAction());
            FilterChain filterChain = protocol.getFilterChain();
            FilterChainContext context = filterChain.obtainFilterChainContext(connection);
            context.setStartIdx(-1);
            context.setFilterIdx(-1);
            context.setEndIdx(filterChain.size());
            this.suspendedContextAttribute.set(context, ctx);
            context.notifyUpstream(event, new InternalCompletionHandler(ctx));
            return ctx.getSuspendAction();
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        return super.handleClose(ctx);
    }

    protected void findProtocol(PUContext puContext, FilterChainContext ctx) {
        PUProtocol[] protocolArray = this.protocols.getArray();
        for (int i = 0; i < protocolArray.length; ++i) {
            PUProtocol protocol = protocolArray[i];
            if ((puContext.skippedProtocolFinders & 1 << i) != 0) continue;
            try {
                ProtocolFinder.Result result = protocol.getProtocolFinder().find(puContext, ctx);
                switch (result) {
                    case FOUND: {
                        puContext.protocol = protocol;
                        return;
                    }
                    case NOT_FOUND: {
                        puContext.skippedProtocolFinders = (short)(puContext.skippedProtocolFinders ^ 1 << i);
                    }
                }
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "ProtocolFinder " + protocol.getProtocolFinder() + " reported error", e);
            }
        }
    }

    private static boolean isUpstream(FilterChainContext context) {
        return context.getStartIdx() < context.getEndIdx();
    }

    private static class InternalCompletionHandler
    implements CompletionHandler<FilterChainContext> {
        private final FilterChainContext suspendedContext;

        public InternalCompletionHandler(FilterChainContext suspendedContext) {
            this.suspendedContext = suspendedContext;
        }

        @Override
        public void cancelled() {
            this.failed(new CancellationException());
        }

        @Override
        public void failed(Throwable throwable) {
            this.suspendedContext.fail(throwable);
        }

        @Override
        public void completed(FilterChainContext context) {
            this.suspendedContext.resume();
        }

        @Override
        public void updated(FilterChainContext result) {
        }
    }

    private class InternalProcessingHandler
    extends EmptyIOEventProcessingHandler {
        private final FilterChainContext parentContext;

        private InternalProcessingHandler(FilterChainContext parentContext) {
            this.parentContext = parentContext;
        }

        @Override
        public void onReregister(Context context) throws IOException {
            FilterChainContext suspendedContext = PUFilter.this.suspendedContextAttribute.get(context);
            assert (suspendedContext != null);
            PUFilter.this.terminateNextActionAttribute.set(this.parentContext, this.parentContext.getSuspendingStopAction());
            suspendedContext.resume();
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            FilterChainContext suspendedContext = PUFilter.this.suspendedContextAttribute.remove(context);
            assert (suspendedContext != null);
            PUFilter.this.terminateNextActionAttribute.set(suspendedContext, suspendedContext.getStopAction());
            suspendedContext.resume();
        }

        @Override
        public void onRerun(Context context, Context newContext) throws IOException {
            if (!PUFilter.this.suspendedContextAttribute.isSet(newContext)) {
                PUFilter.this.suspendedContextAttribute.set(newContext, this.parentContext.copy());
            }
        }
    }
}

