/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.utils.EnsurePath;
import com.netflix.curator.utils.ZKPaths;

class NamespaceImpl {
    private final CuratorFrameworkImpl client;
    private final String namespace;
    private final EnsurePath ensurePath;

    NamespaceImpl(CuratorFrameworkImpl curatorFrameworkImpl, String string) {
        this.client = curatorFrameworkImpl;
        this.namespace = string;
        this.ensurePath = string != null ? new EnsurePath(ZKPaths.makePath((String)"/", (String)string)) : null;
    }

    String getNamespace() {
        return this.namespace;
    }

    String unfixForNamespace(String string) {
        String string2;
        if (this.namespace != null && string != null && string.startsWith(string2 = ZKPaths.makePath((String)this.namespace, null))) {
            string = string.length() > string2.length() ? string.substring(string2.length()) : "/";
        }
        return string;
    }

    String fixForNamespace(String string) {
        if (this.ensurePath != null) {
            try {
                this.ensurePath.ensure(this.client.getZookeeperClient());
            }
            catch (Exception exception) {
                this.client.logError("Ensure path threw exception", exception);
            }
        }
        return ZKPaths.fixForNamespace((String)this.namespace, (String)string);
    }

    EnsurePath newNamespaceAwareEnsurePath(String string) {
        return new EnsurePath(this.fixForNamespace(string));
    }
}

