/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.state;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.listen.ListenerContainer;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.framework.state.ConnectionStateListener;
import com.netflix.curator.utils.ThreadUtils;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStateManager
implements Closeable {
    private static final int QUEUE_SIZE;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<ConnectionState> eventQueue = new ArrayBlockingQueue<ConnectionState>(QUEUE_SIZE);
    private final CuratorFramework client;
    private final ThreadFactory threadFactory;
    private final ListenerContainer<ConnectionStateListener> listeners = new ListenerContainer();
    private final AtomicReference<ConnectionState> currentState = new AtomicReference();
    private volatile ExecutorService service;

    public ConnectionStateManager(CuratorFramework curatorFramework, ThreadFactory threadFactory) {
        this.client = curatorFramework;
        if (threadFactory == null) {
            threadFactory = ThreadUtils.newThreadFactory((String)"ConnectionStateManager");
        }
        this.threadFactory = threadFactory;
    }

    public void start() {
        Preconditions.checkState((this.service == null ? 1 : 0) != 0, (Object)"already started");
        this.service = Executors.newSingleThreadExecutor(this.threadFactory);
        this.service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ConnectionStateManager.this.processEvents();
                return null;
            }
        });
    }

    @Override
    public void close() {
        Preconditions.checkState((this.service != null ? 1 : 0) != 0, (Object)"not started");
        Preconditions.checkState((!this.service.isShutdown() ? 1 : 0) != 0, (Object)"already closed");
        this.service.shutdownNow();
        this.listeners.clear();
    }

    public ListenerContainer<ConnectionStateListener> getListenable() {
        return this.listeners;
    }

    public void addStateChange(ConnectionState connectionState) {
        if (this.service.isShutdown()) {
            return;
        }
        ConnectionState connectionState2 = this.currentState.getAndSet(connectionState);
        if (connectionState2 == connectionState) {
            return;
        }
        ConnectionState connectionState3 = connectionState2 == null ? ConnectionState.CONNECTED : connectionState;
        this.log.info("State change: " + (Object)((Object)connectionState3));
        while (!this.eventQueue.offer(connectionState3)) {
            this.eventQueue.poll();
            this.log.warn("ConnectionStateManager queue full - dropping events to make room");
        }
    }

    private void processEvents() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                final ConnectionState connectionState = this.eventQueue.take();
                if (this.listeners.size() == 0) {
                    this.log.warn("There are no ConnectionStateListeners registered.");
                }
                this.listeners.forEach(new Function<ConnectionStateListener, Void>(){

                    public Void apply(ConnectionStateListener connectionStateListener) {
                        connectionStateListener.stateChanged(ConnectionStateManager.this.client, connectionState);
                        return null;
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        int n = 25;
        String string = System.getProperty("ConnectionStateManagerSize", null);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        QUEUE_SIZE = n;
    }
}

