/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.simple.pages;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.container.page.Page;
import com.alibaba.dubbo.container.page.PageHandler;
import com.alibaba.dubbo.monitor.simple.SimpleMonitorService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartsPageHandler
implements PageHandler {
    public Page handle(URL url) {
        String service = url.getParameter("service");
        if (service == null || service.length() == 0) {
            throw new IllegalArgumentException("Please input service parameter.");
        }
        String date = url.getParameter("date");
        if (date == null || date.length() == 0) {
            date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        }
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        String directory = SimpleMonitorService.getInstance().getChartsDirectory();
        File chartsDir = new File(directory);
        String filename = directory + "/" + date + "/" + service;
        File serviceDir = new File(filename);
        if (serviceDir.exists()) {
            File[] methodDirs;
            for (File methodDir : methodDirs = serviceDir.listFiles()) {
                String methodUri = chartsDir.getName() + "/" + date + "/" + service + "/" + methodDir.getName() + "/";
                rows.add(this.toRow(methodDir, methodUri));
            }
        }
        StringBuilder nav = new StringBuilder();
        nav.append("<a href=\"services.html\">Services</a> &gt; ");
        nav.append(service);
        nav.append(" &gt; <a href=\"providers.html?service=");
        nav.append(service);
        nav.append("\">Providers</a> | <a href=\"consumers.html?service=");
        nav.append(service);
        nav.append("\">Consumers</a> | <a href=\"statistics.html?service=");
        nav.append(service);
        nav.append("&date=");
        nav.append(date);
        nav.append("\">Statistics</a> | Charts &gt; <input type=\"text\" style=\"width: 65px;\" name=\"date\" value=\"");
        nav.append(date);
        nav.append("\" onkeyup=\"if (event.keyCode == 10 || event.keyCode == 13) {window.location.href='charts.html?service=");
        nav.append(service);
        nav.append("&date=' + this.value;}\" />");
        return new Page(nav.toString(), "Charts (" + rows.size() + ")", new String[]{"Method", "Requests per second (QPS)", "Average response time (ms)"}, rows);
    }

    private List<String> toRow(File dir, String uri) {
        String url;
        ArrayList<String> row = new ArrayList<String>();
        row.add(dir.getName());
        if (new File(dir, "success.png").exists()) {
            url = uri + "success" + ".png";
            row.add("<a href=\"" + url + "\" target=\"_blank\"><img src=\"" + url + "\" style=\"width: 100%;\" border=\"0\" /></a>");
        } else {
            row.add("");
        }
        if (new File(dir, "elapsed.png").exists()) {
            url = uri + "elapsed" + ".png";
            row.add("<a href=\"" + url + "\" target=\"_blank\"><img src=\"" + url + "\" style=\"width: 100%;\" border=\"0\" /></a>");
        } else {
            row.add("");
        }
        return row;
    }
}

