/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.simple;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.RegistryService;
import com.alibaba.dubbo.registry.support.AbstractRegistry;
import com.alibaba.dubbo.rpc.RpcContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRegistryService
extends AbstractRegistry {
    private final ConcurrentMap<String, Set<URL>> remoteRegistered = new ConcurrentHashMap<String, Set<URL>>();
    private final ConcurrentMap<String, ConcurrentMap<URL, Set<NotifyListener>>> remoteSubscribed = new ConcurrentHashMap<String, ConcurrentMap<URL, Set<NotifyListener>>>();
    private static final Logger logger = LoggerFactory.getLogger(SimpleRegistryService.class);

    public SimpleRegistryService() {
        super(new URL("dubbo", NetUtils.getLocalHost(), 0, RegistryService.class.getName(), new String[]{"file", "N/A"}));
    }

    public boolean isAvailable() {
        return true;
    }

    public List<URL> lookup(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL u : this.getRegistered()) {
            if (!UrlUtils.isMatch((URL)url, (URL)u)) continue;
            urls.add(u);
        }
        return urls;
    }

    public void register(URL url) {
        String client = RpcContext.getContext().getRemoteAddressString();
        Set urls = (Set)this.remoteRegistered.get(client);
        if (urls == null) {
            this.remoteRegistered.putIfAbsent(client, (Set<URL>)new ConcurrentHashSet());
            urls = (Set)this.remoteRegistered.get(client);
        }
        urls.add(url);
        super.register(url);
        this.registered(url);
    }

    public void unregister(URL url) {
        String client = RpcContext.getContext().getRemoteAddressString();
        Set urls = (Set)this.remoteRegistered.get(client);
        if (urls != null && urls.size() > 0) {
            urls.remove(url);
        }
        super.unregister(url);
        this.unregistered(url);
    }

    public void subscribe(URL url, NotifyListener listener) {
        Set listeners;
        String client;
        ConcurrentMap clientListeners;
        URL registryUrl;
        if (this.getUrl().getPort() == 0 && (registryUrl = RpcContext.getContext().getUrl()) != null && registryUrl.getPort() > 0 && RegistryService.class.getName().equals(registryUrl.getPath())) {
            super.setUrl(registryUrl);
            super.register(registryUrl);
        }
        if ((clientListeners = (ConcurrentMap)this.remoteSubscribed.get(client = RpcContext.getContext().getRemoteAddressString())) == null) {
            this.remoteSubscribed.putIfAbsent(client, new ConcurrentHashMap());
            clientListeners = (ConcurrentMap)this.remoteSubscribed.get(client);
        }
        if ((listeners = (Set)clientListeners.get(url)) == null) {
            clientListeners.putIfAbsent(url, new ConcurrentHashSet());
            listeners = (Set)clientListeners.get(url);
        }
        listeners.add(listener);
        super.subscribe(url, listener);
        this.subscribed(url, listener);
    }

    public void unsubscribe(URL url, NotifyListener listener) {
        Set listeners;
        String client;
        Map clientListeners;
        if (!"*".equals(url.getServiceInterface()) && url.getParameter("register", true)) {
            this.unregister(url);
        }
        if ((clientListeners = (Map)this.remoteSubscribed.get(client = RpcContext.getContext().getRemoteAddressString())) != null && clientListeners.size() > 0 && (listeners = (Set)clientListeners.get(url)) != null && listeners.size() > 0) {
            listeners.remove(listener);
        }
    }

    protected void registered(URL url) {
        for (Map.Entry entry : this.getSubscribed().entrySet()) {
            URL key = (URL)entry.getKey();
            if (!UrlUtils.isMatch((URL)key, (URL)url)) continue;
            List<URL> list = this.lookup(key);
            for (NotifyListener listener : (Set)entry.getValue()) {
                listener.notify(list);
            }
        }
    }

    protected void unregistered(URL url) {
        for (Map.Entry entry : this.getSubscribed().entrySet()) {
            URL key = (URL)entry.getKey();
            if (!UrlUtils.isMatch((URL)key, (URL)url)) continue;
            List<URL> list = this.lookup(key);
            for (NotifyListener listener : (Set)entry.getValue()) {
                listener.notify(list);
            }
        }
    }

    protected void subscribed(final URL url, final NotifyListener listener) {
        if ("*".equals(url.getServiceInterface())) {
            new Thread(new Runnable(){

                public void run() {
                    HashMap<String, ArrayList<URL>> map = new HashMap<String, ArrayList<URL>>();
                    for (URL u : SimpleRegistryService.this.getRegistered()) {
                        if (!UrlUtils.isMatch((URL)url, (URL)u)) continue;
                        String service = u.getServiceInterface();
                        ArrayList<URL> list = (ArrayList<URL>)map.get(service);
                        if (list == null) {
                            list = new ArrayList<URL>();
                            map.put(service, list);
                        }
                        list.add(u);
                    }
                    for (List list : map.values()) {
                        try {
                            listener.notify(list);
                        }
                        catch (Throwable e) {
                            logger.warn("Discard to notify " + url.getServiceKey() + " to listener " + listener);
                        }
                    }
                }
            }, "DubboMonitorNotifier").start();
        } else {
            List<URL> list = this.lookup(url);
            try {
                listener.notify(list);
            }
            catch (Throwable e) {
                logger.warn("Discard to notify " + url.getServiceKey() + " to listener " + listener);
            }
        }
    }

    public void disconnect() {
        Map listeners;
        Set urls;
        String client = RpcContext.getContext().getRemoteAddressString();
        if (logger.isInfoEnabled()) {
            logger.info("Disconnected " + client);
        }
        if ((urls = (Set)this.remoteRegistered.get(client)) != null && urls.size() > 0) {
            for (URL url : urls) {
                this.unregister(url);
            }
        }
        if ((listeners = (Map)this.remoteSubscribed.get(client)) != null && listeners.size() > 0) {
            for (Map.Entry entry : listeners.entrySet()) {
                URL url = (URL)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    this.unsubscribe(url, listener);
                }
            }
        }
    }
}

