/*
 * Decompiled with CFR 0.152.
 */
package com.citic.combpre.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static Logger logger = LoggerFactory.getLogger(AESUtil.class);
    private static int KeySizeAES128 = 16;

    private static Cipher getCipher(int mode, String key) {
        byte[] keyPtr = new byte[KeySizeAES128];
        IvParameterSpec ivParam = new IvParameterSpec(keyPtr);
        byte[] passPtr = key.getBytes();
        try {
            Cipher mCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            for (int i = 0; i < KeySizeAES128; ++i) {
                keyPtr[i] = i < passPtr.length ? passPtr[i] : (byte)0;
            }
            SecretKeySpec keySpec = new SecretKeySpec(keyPtr, "AES");
            mCipher.init(mode, (Key)keySpec, ivParam);
            return mCipher;
        }
        catch (InvalidKeyException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            logger.error("error occur", (Throwable)e);
        }
        return null;
    }

    public static byte[] encrypt(String content, String password) {
        try {
            Cipher cipher = AESUtil.getCipher(1, password);
            byte[] result = cipher.doFinal(content.getBytes("UTF-8"));
            return result;
        }
        catch (Exception e) {
            logger.error("error occur", (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] content, String password) {
        try {
            Cipher cipher = AESUtil.getCipher(2, password);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            logger.error("error occur", (Throwable)e);
            return null;
        }
    }

    public static byte[] encrypt1(String content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(password.getBytes("UTF-8"));
            kgen.init(128, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes("utf-8");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (NoSuchPaddingException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error("error occur", (Throwable)e);
        }
        return null;
    }

    public static byte[] decrypt1(byte[] content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(password.getBytes("UTF-8"));
            kgen.init(128, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error("error occur", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("error occur", (Throwable)e);
        }
        return null;
    }

    public static String getRandomAESKey() {
        int $aes_ken_len = 16;
        String aes_key_str = "";
        char[] e = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        int index = 0;
        Random r = new Random();
        for (int i = 0; i < $aes_ken_len; ++i) {
            index = r.nextInt(64);
            aes_key_str = aes_key_str + e[index];
        }
        return aes_key_str;
    }
}

