/*
 * Decompiled with CFR 0.152.
 */
package com.citic.combpre.util;

import com.citic.openbank.sdk.AppException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombUtil {
    private static Logger logger = LoggerFactory.getLogger(CombUtil.class);

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static String gbkToISO8859_1(String str) throws AppException {
        return CombUtil.encodingCnv(str, "GBK", "ISO-8859-1");
    }

    public static String gbkToUFT8(String str) throws AppException {
        return CombUtil.encodingCnv(str, "GBK", "UTF-8");
    }

    public static String utf8ToGbk(String str) throws AppException {
        return CombUtil.encodingCnv(str, "UTF-8", "GBK");
    }

    public static String utf8ToISO8859_1(String str) throws AppException {
        return CombUtil.encodingCnv(str, "UTF-8", "ISO-8859-1");
    }

    public static String iso8859_1ToUTF8(String str) throws AppException {
        return CombUtil.encodingCnv(str, "ISO-8859-1", "UTF-8");
    }

    public static String iso8859_1ToGbk(String str) throws AppException {
        return CombUtil.encodingCnv(str, "ISO-8859-1", "GBK");
    }

    public static String iso8859_1ToSysEncoding(String str) throws AppException {
        return CombUtil.encodingCnv(str, "ISO-8859-1", System.getProperty("file.encoding"));
    }

    public static String sysEncodingToIso8859_1(String str) throws AppException {
        return CombUtil.encodingCnv(str, System.getProperty("file.encoding"), "ISO-8859-1");
    }

    public static String encodingCnv(String str, String encodingA, String encodingB) throws AppException {
        try {
            str = new String(str.getBytes(encodingA), encodingB);
        }
        catch (Exception e) {
            logger.error("I010000" + CombUtil.gbkToISO8859_1("\u5b57\u7b26\u4e32\u7f16\u7801\u8f6c\u6362\u9519\u8bef"));
            throw new AppException("IF01034", e);
        }
        return str;
    }

    public static int strLengthIsoToSys(String str1) throws AppException {
        return CombUtil.strLength(str1, "ISO-8859-1", System.getProperty("file.encoding"));
    }

    public static int strLength(String str1, String encodingA, String encodingB) throws AppException {
        boolean bHasDBC = false;
        int iTotalLen = 0;
        int iDBCCout = 0;
        String str = !CombUtil.isEmpty(encodingA) && !CombUtil.isEmpty(encodingB) ? CombUtil.encodingCnv(str1, encodingA, encodingB) : str1;
        byte[] strbytes = str.getBytes();
        if (0 < str.length()) {
            for (int i = 0; i < strbytes.length; ++i) {
                byte btFirst = strbytes[i];
                if (128 < btFirst || btFirst < 0) {
                    ++i;
                    bHasDBC = true;
                    ++iDBCCout;
                    continue;
                }
                if (bHasDBC) {
                    ++iTotalLen;
                    bHasDBC = false;
                    iTotalLen += ++iDBCCout * 2;
                    iDBCCout = 0;
                    continue;
                }
                ++iTotalLen;
            }
            if (bHasDBC) {
                iTotalLen += ++iDBCCout * 2;
            }
        }
        return iTotalLen;
    }

    public static boolean strLengthChkIsoToSys(String str1, int len) throws AppException {
        return CombUtil.strLengthChk(str1, len, "ISO-8859-1", System.getProperty("file.encoding"));
    }

    public static boolean strLengthChk(String str1, int len, String encodingA, String encodingB) throws AppException {
        boolean bRet = true;
        int iTotalLen = CombUtil.strLength(str1, encodingA, encodingB);
        if (len < iTotalLen) {
            bRet = false;
        }
        return bRet;
    }

    public static boolean strFixedLengthChkIsoToSys(String str1, int len) throws AppException {
        return CombUtil.strFixedLengthChk(str1, len, "ISO-8859-1", System.getProperty("file.encoding"));
    }

    public static boolean strFixedLengthChk(String str1, int len, String encodingA, String encodingB) throws AppException {
        boolean bRet = false;
        int iTotalLen = CombUtil.strLength(str1, encodingA, encodingB);
        if (len == iTotalLen) {
            bRet = true;
        }
        return bRet;
    }

    public static String[] strSplit(String src, String spit) {
        int index = 0;
        Vector<String> vector = new Vector<String>();
        String[] as = new String[1];
        if (src == null) {
            return new String[0];
        }
        if (spit == null) {
            return null;
        }
        if (src.trim().equals("")) {
            return new String[0];
        }
        index = src.indexOf(spit);
        String tem = "";
        while (index != -1) {
            if (index != 0 && src.substring(index - 1, index).equals("\\")) {
                tem = tem + src.substring(0, index - 1) + spit;
                src = src.substring(index + 1);
                index = src.indexOf(spit);
                continue;
            }
            String tem2 = tem.equals("") ? src.substring(0, index).trim() : tem + src.substring(0, index).trim();
            src = src.substring(index + 1);
            vector.addElement(tem2);
            tem = "";
            index = src.indexOf(spit);
        }
        vector.addElement(src.trim());
        as = new String[vector.size()];
        for (int j = 0; j < vector.size(); ++j) {
            as[j] = (String)vector.elementAt(j);
        }
        return as;
    }

    public static boolean isFloat(String valueStr, int maxLength, int precision) throws AppException {
        boolean result = false;
        int length = maxLength - precision;
        if (CombUtil.isEmpty(valueStr)) {
            return false;
        }
        if (valueStr.indexOf("-") == 0) {
            valueStr = valueStr.substring(1);
        }
        try {
            Object[] array = CombUtil.strSplit(valueStr, ".");
            if (CombUtil.isEmpty(array) || array.length > 2) {
                return false;
            }
            if (((String)array[0]).length() > length || ((String)array[0]).length() < 1) {
                return false;
            }
            if (array.length == 2 && (((String)array[1]).length() > precision || ((String)array[1]).length() < 1)) {
                return false;
            }
            if (valueStr.matches("[0-9]*")) {
                result = true;
            } else if (valueStr.matches("[0-9]*\\.[0-9]*")) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error("I010001" + CombUtil.gbkToISO8859_1("\u5224\u65ad\u6d6e\u70b9\u7c7b\u578b\u6570\u5931\u8d25"));
            throw new AppException("IF01035", e);
        }
        return result;
    }

    public static String fillZeroLeft(String content, int length) {
        int contentLen = content.getBytes().length;
        if (contentLen >= length) {
            return content;
        }
        int index = length - contentLen;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < index; ++i) {
            buffer.append("0");
        }
        buffer.append(content);
        return buffer.toString();
    }

    public static String nullToSpace(Object str) {
        if (str == null) {
            return "";
        }
        return str.toString().trim();
    }

    public static String getUnderlineColumn(String column) {
        if (CombUtil.isEmpty(column)) {
            return "";
        }
        if ("_".equals(column.toString().substring(0, 1))) {
            column = column.substring(1, column.length());
        }
        StringBuilder ulcolumn = new StringBuilder();
        if (column.indexOf("_") == -1) {
            char[] cls = column.toCharArray();
            int i = 0;
            int upperCaseIndex = 0;
            for (char cl : cls) {
                if (Character.isUpperCase(cl)) {
                    ulcolumn.append("_");
                    ulcolumn.append(cl);
                    ++upperCaseIndex;
                } else {
                    ulcolumn.append(String.valueOf(cl));
                }
                ++i;
            }
            if (i == upperCaseIndex) {
                return column;
            }
            if (upperCaseIndex == 0) {
                return column;
            }
        } else {
            ulcolumn.append(column);
        }
        return ulcolumn.toString();
    }

    public static boolean contains(String[] stringArray, String str) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        if (CombUtil.isEmpty(str)) {
            return false;
        }
        List<String> list = Arrays.asList(stringArray);
        return list.contains(str);
    }

    public static String getErrCodeByErrMsg(String errMsg) {
        if (errMsg.length() >= 7) {
            return errMsg.substring(0, 7);
        }
        return "IMENOLG";
    }

    public static String getNotExistErrCodeMsg(String errMsg) {
        if (errMsg.length() >= 7) {
            String exmsg = errMsg.substring(7);
            if (!CombUtil.isEmpty(exmsg) && ":".equals(exmsg.substring(0, 1))) {
                return errMsg.substring(8);
            }
            return errMsg;
        }
        return errMsg;
    }

    public static String getStringFromDynParam(int index, String str, String flag, String regexFlag, String[] ss) {
        if (str.contains(flag) && index <= ss.length - 1) {
            str = str.replaceFirst(regexFlag, ss[index]);
            str = CombUtil.getStringFromDynParam(index + 1, str, flag, regexFlag, ss);
        }
        return str;
    }

    public static boolean isNumber(String str) {
        boolean result = false;
        if (!CombUtil.isEmpty(str) && str.matches("[0-9]*")) {
            result = true;
        }
        return result;
    }

    public static boolean isFloat2(String valueStr, int maxLength, int precision) {
        boolean result = false;
        if (CombUtil.isEmpty(valueStr)) {
            return false;
        }
        if (valueStr.indexOf("-") == 0) {
            valueStr = valueStr.substring(1);
        }
        if (valueStr.matches("[0-9]*")) {
            valueStr = valueStr + ".";
        }
        int srcprecision = valueStr.length() - valueStr.indexOf(".") - 1;
        int count = precision - srcprecision;
        for (int i = 0; i < count; ++i) {
            valueStr = valueStr + "0";
        }
        if (valueStr.length() > maxLength + 1) {
            return false;
        }
        if (valueStr.matches("[0-9]*\\.[0-9]{" + precision + "}")) {
            result = true;
        }
        return result;
    }

    public static String gbkToISO(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] b = str.getBytes("GBK");
            String rstr = new String(b, "ISO8859-1");
            return rstr;
        }
        catch (Exception e) {
            logger.error("Utility.gbk2ISO(" + str + ")---" + e.toString());
            return null;
        }
    }

    public static boolean isTime(String str) {
        boolean result = false;
        Time tem = null;
        try {
            tem = CombUtil.strToTime(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tem != null) {
            result = true;
        }
        return result;
    }

    public static Time strToTime(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (str.length() == 6) {
            str = CombUtil.formatTime6ToTime8(str);
        }
        if (Integer.parseInt(str.substring(0, 2)) > 23) {
            return null;
        }
        if (Integer.parseInt(str.substring(3, 5)) > 59) {
            return null;
        }
        if (Integer.parseInt(str.substring(6)) > 59) {
            return null;
        }
        return Time.valueOf(str);
    }

    public static String formatTime6ToTime8(String valueStr) {
        if (valueStr == null || valueStr.trim().equals("")) {
            return valueStr;
        }
        if (valueStr.matches("[0-9]{6}")) {
            String newValue = valueStr.substring(0, 2) + ":" + valueStr.substring(2, 4) + ":" + valueStr.substring(4);
            return newValue;
        }
        return valueStr;
    }

    public static boolean isDate(String fieldValue) {
        boolean result = false;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            if (fieldValue.equals(sdf.format(sdf.parse(fieldValue)))) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getAfter5Time() {
        String result = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Calendar beforeTime = Calendar.getInstance();
            beforeTime.add(12, 5);
            Date date = beforeTime.getTime();
            result = sdf.format(date);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String ISOToGbk(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] b = str.getBytes("ISO-8859-1");
            String rstr = new String(b, "GBK");
            return rstr;
        }
        catch (Exception e) {
            logger.error("ISOToGbk(" + str + ")---" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static String ISOToUtf(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] b = str.getBytes("ISO-8859-1");
            String rstr = new String(b, "UTF-8");
            return rstr;
        }
        catch (Exception e) {
            logger.error("Utility.gbk2ISO(" + str + ")---" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static String changeIdNo(String idNo) {
        if (!CombUtil.isEmpty(idNo) && "x".equals(idNo.trim().substring(idNo.length() - 1))) {
            idNo = idNo.trim().replaceAll("x$", "X");
        }
        return idNo;
    }
}

