/*
 * Decompiled with CFR 0.152.
 */
package com.citic.openbank.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

public class OpenBankSdkConfiguration {
    private String publicUrl;
    private int connectionTimeout = -1;
    private String openVer;
    private String openMerCode;
    private String openMerName;
    private String openBusiType;
    private String transferEncode;
    private static OpenBankSdkConfiguration configuration;

    public String getOpenVer() {
        return this.openVer;
    }

    public void setOpenVer(String openVer) {
        this.openVer = openVer;
    }

    public String getOpenMerCode() {
        return this.openMerCode;
    }

    public void setOpenMerCode(String openMerCode) {
        this.openMerCode = openMerCode;
    }

    public String getOpenMerName() {
        return this.openMerName;
    }

    public void setOpenMerName(String openMerName) {
        this.openMerName = openMerName;
    }

    public String getOpenBusiType() {
        return this.openBusiType;
    }

    public void setOpenBusiType(String openBusiType) {
        this.openBusiType = openBusiType;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public static OpenBankSdkConfiguration getConfigurationFromFile() {
        if (configuration == null) {
            configuration = new OpenBankSdkConfiguration();
            URL file = OpenBankSdkConfiguration.class.getClassLoader().getResource("citic/conf/config.properties");
            if (file == null) {
                throw new RuntimeException("\u672a\u80fd\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6, \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u662f\u5426\u5728 classpath \u4e2d");
            }
            String path = file.getPath();
            try {
                FileInputStream inputStream = new FileInputStream(path);
                Properties props = new Properties();
                props.load(new InputStreamReader((InputStream)inputStream, "utf-8"));
                configuration.setPublicUrl(props.getProperty("public_url"));
                configuration.setConnectionTimeout(Integer.valueOf(props.getProperty("connection_timeout")));
                configuration.setTransferEncode(props.getProperty("transfer_encode"));
                configuration.setOpenVer(props.getProperty("open_ver"));
                configuration.setOpenBusiType(props.getProperty("open_busi_type"));
                configuration.setOpenMerCode(props.getProperty("open_mer_code"));
                configuration.setOpenMerName(props.getProperty("open_mer_name"));
                if (configuration.getOpenBusiType() == null || "".equals(configuration.getOpenBusiType())) {
                    throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_busi_type \u53d8\u91cf");
                }
                if (configuration.getOpenVer() == null || "".equals(configuration.getOpenVer())) {
                    throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_ver \u53d8\u91cf");
                }
                if (configuration.getOpenMerCode() == null || "".equals(configuration.getOpenMerCode())) {
                    throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_mer_code \u53d8\u91cf");
                }
                if (configuration.getOpenMerName() == null || "".equals(configuration.getOpenMerName())) {
                    throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_mer_name \u53d8\u91cf");
                }
                if (configuration.getPublicUrl() == null || "".equals(configuration.getPublicUrl())) {
                    throw new IllegalArgumentException("\u672a\u8bbe\u7f6e public_url \u53d8\u91cf");
                }
                if (configuration.getTransferEncode() == null || "".equals(configuration.getTransferEncode())) {
                    throw new IllegalArgumentException("\u672a\u8bbe\u7f6e transfer_encode \u53d8\u91cf");
                }
                if (configuration.getConnectionTimeout() == -1) {
                    throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_mer_name \u53d8\u91cf");
                }
                return configuration;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return configuration;
    }

    public String getTransferEncode() {
        return this.transferEncode;
    }

    public void setTransferEncode(String transferEncode) {
        this.transferEncode = transferEncode;
    }
}

