/*
 * Decompiled with CFR 0.152.
 */
package com.citic.openbank.sdk;

import com.citic.openbank.configuration.OpenBankSdkConfiguration;
import com.citic.openbank.sdk.AppException;
import com.citic.openbank.sdk.CiticSdk;
import com.citic.openbank.sdk.CiticSdkInterface;
import com.citic.openbank.sdk.RequestHeader;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.FileUtil;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API {
    private static Logger logger = LoggerFactory.getLogger(CiticSdk.class);
    private static CiticSdkInterface sdk;
    private static boolean hasInit;
    private static Object syncInitObj;
    static String json1;
    static String json2;
    static String json3;

    protected static void setPrivateKeyDecryptWithPwd(CiticSdkInterface sdk) throws Exception {
        URL keyFileUrl = API.class.getClassLoader().getResource("citic/key/decrypt.priv.key");
        if (keyFileUrl == null) {
            logger.error("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/decrypt.priv.key");
            throw new RuntimeException("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/decrypt.priv.key");
        }
        String fileUrlPath = keyFileUrl.getPath();
        byte[] base64EncodedPrivatekey = FileUtil.read4file(fileUrlPath);
        URL pwdFileUrl = API.class.getClassLoader().getResource("citic/key/decrypt.priv.pwd");
        if (pwdFileUrl == null) {
            logger.error("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/decrypt.priv.pwd");
            throw new RuntimeException("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/decrypt.priv.pwd");
        }
        String pwdFiePath = pwdFileUrl.getPath();
        byte[] pwd = FileUtil.read4file(pwdFiePath);
        sdk.setPrivateKeyDecryptWithPwd(Base64.decode(base64EncodedPrivatekey), pwd);
    }

    protected static void setPrivateKeySignatureWithPwd(CiticSdkInterface sdk) throws Exception {
        URL keyFileUrl = API.class.getClassLoader().getResource("citic/key/signature.priv.key");
        if (keyFileUrl == null) {
            logger.error("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/signature.priv.key");
            throw new RuntimeException("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/signature.priv.key");
        }
        String fileUrlPath = keyFileUrl.getPath();
        byte[] base64EncodedPrivatekey = FileUtil.read4file(fileUrlPath);
        URL pwdFileUrl = API.class.getClassLoader().getResource("citic/key/signature.priv.pwd");
        if (pwdFileUrl == null) {
            logger.error("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/signature.priv.pwd");
            throw new RuntimeException("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/signature.priv.pwd");
        }
        String pwdFiePath = pwdFileUrl.getPath();
        byte[] pwd = FileUtil.read4file(pwdFiePath);
        sdk.setPrivateKeySignatureWithPwd(Base64.decode(base64EncodedPrivatekey), pwd);
    }

    protected static void setPublicKeyEncrypt(CiticSdkInterface sdk) throws Exception {
        URL keyFileUrl = API.class.getClassLoader().getResource("citic/key/encrypt.pub.key");
        if (keyFileUrl == null) {
            logger.error("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/encrypt.pub.key");
            throw new RuntimeException("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/encrypt.pub.key");
        }
        String fileUrlPath = keyFileUrl.getPath();
        byte[] base64EncodedPublickey = FileUtil.read4file(fileUrlPath);
        sdk.setPublicKeyEncrypt(Base64.decode(base64EncodedPublickey));
    }

    protected static void setPublicKeyValidateSignature(CiticSdkInterface sdk) throws Exception {
        URL keyFileUrl = API.class.getClassLoader().getResource("citic/key/validate-signature.pub.key");
        if (keyFileUrl == null) {
            logger.error("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/validate-signature.pub.key");
            throw new RuntimeException("classpath \u4e0b\u672a\u80fd\u627e\u5230 citic/key/validate-signature.pub.key");
        }
        String fileUrlPath = keyFileUrl.getPath();
        byte[] base64EncodedPublickey = FileUtil.read4file(fileUrlPath);
        sdk.setPublicKeyValidateSignature(Base64.decode(base64EncodedPublickey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initAPI() throws Exception {
        if (hasInit) {
            return;
        }
        Object object = syncInitObj;
        synchronized (object) {
            if (hasInit) {
                return;
            }
            sdk = CiticSdk.getInstance();
            API.setPrivateKeyDecryptWithPwd(sdk);
            API.setPrivateKeySignatureWithPwd(sdk);
            API.setPublicKeyEncrypt(sdk);
            API.setPublicKeyValidateSignature(sdk);
            OpenBankSdkConfiguration configuration = OpenBankSdkConfiguration.getConfigurationFromFile();
            sdk.setConnectionTimeout(configuration.getConnectionTimeout());
            sdk.setOpenBusiType(configuration.getOpenBusiType());
            sdk.setOpenMerCode(configuration.getOpenMerCode());
            sdk.setOpenMerName(configuration.getOpenMerName());
            sdk.setOpenVer(configuration.getOpenVer());
            sdk.setPublicUrl(configuration.getPublicUrl());
            sdk.setTransferEncode(configuration.getTransferEncode());
            hasInit = true;
        }
    }

    public static String signature(String input) throws AppException {
        try {
            API.initAPI();
        }
        catch (Exception e) {
            logger.error("Init App error", (Throwable)e);
            throw new AppException("IF01009", e);
        }
        return sdk.signature(input);
    }

    public static String decryptDataFromBusiness(String encryptBusinessData) throws AppException {
        try {
            API.initAPI();
        }
        catch (Exception e) {
            logger.error("Init App error", (Throwable)e);
            throw new AppException("IF01009", e);
        }
        return sdk.decryptDataFromBusiness(encryptBusinessData);
    }

    public static String remoteCall(RequestHeader header, String reqBody) throws AppException {
        try {
            API.initAPI();
        }
        catch (Exception e) {
            logger.error("Init App error", (Throwable)e);
            throw new AppException("IF01009", e);
        }
        return sdk.remoteCall(header, reqBody);
    }

    public static String validateSignature(String input) throws AppException {
        try {
            API.initAPI();
        }
        catch (Exception e) {
            logger.error("Init App error", (Throwable)e);
            throw new AppException("IF01009", e);
        }
        return sdk.validateSignature(input);
    }

    public static String encryptBusiness(String data) throws AppException {
        try {
            API.initAPI();
        }
        catch (Exception e) {
            logger.error("Init App error", (Throwable)e);
            throw new AppException("IF01009", e);
        }
        return sdk.encryptBusiness(data);
    }

    public static void main(String[] arts) {
        logger.info("==========================================");
        System.out.println(System.getProperty("java.class.path"));
        System.out.println(System.getProperty("user.dir"));
        try {
            RequestHeader header = new RequestHeader();
            header.setOpenMerFlowId("ABCD123456");
            header.setOpenTransCode("IFOPI001");
            String json = json1;
            String string = API.remoteCall(header, json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        hasInit = false;
        syncInitObj = new Object();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        json1 = "{\n\n  \"serviceCode\":\"I0015050\",\n  \"PLATFORMID\":\"PLKH\",\n  \"SUBNUMBER\":\"0001\",\n  \"SUBNAME\":\"\u5546\u673a\u540d\u79f01\",\n  \"ISBSNSPCSCUST\":\"0\",\n  \"CRENTP\":\"\",\n  \"CRENTPBRANCH\":\"\",\n  \"CHNLID\":\"IFOP\",\n  \"OPENID\":\"\",\n  \"RSRVTNMBLNBR\":\"18888888888\",\n  \"VEOBATNUM\":\"TESTVIDEO0001\",\n  \"BOPENBR\":\"724100\",\n  \"BOPENET\":\"724151\",\n  \"DEPNAME\":\"123456\",\n  \"DEPNAMEFROM\":\"1\",\n  \"ISIOTEIO\":\"1\",\n  \"ACCCHAR\":\"1\",\n  \"SIGNBSNCODES\":\"P01001001007||P01001001001\",\n  \"DAYLMT\":\"99999999\",\n  \"YEARLMT\":\"99999999\",\n  \"YEARNBR\":\"99999999\",\n  \n  \n  \"IDINFLIST\":[\n    {\n      \"RELPTYPE\":\"1\",\n      \"NAME\":\"\",\n      \"ISOWNER\":\"\",\n      \"UNITPNPTP\":\"\",\n      \"RELINFTYPE\":\"1\",\n      \"NATION\":\"\",\n      \"IDTYPE\":\"\",\n      \"IDNO\":\"\",\n      \"STDATE\":\"\",\n      \"ENDATE\":\"\",\n      \"MOBILE\":\"\",\n      \"PHONE\":\"\"\n    }\n  ],\n  \n  \"ADDINFLIST\":[\n    {\n      \"ADDTYPE\":\"105\",\n      \"STATE\":\"\",\n      \"PROV\":\"\",\n      \"CITY\":\"\",\n      \"COUNTRY\":\"\",\n      \"POSTCODE\":\"\",\n      \"ADDINF\":\"\",\n      \"RELINFTYPE\":\"1\",\n      \"ADDSEQ\":\"\"\n    }\n  ],\n  \"SIGNINFLIST\":[\n    {\n      \"SIGNTYPE\":\"0\",\n      \"SIGNSTT\":\"1\",\n      \"HASPSD\":\"\",\n      \"ISADDTOPSD\":\"\",\n      \"PSDNO\":\"\"\n  \n    }\n  ],\n  \"SIGNOPRINFLIST\":[\n    {\n      \"FLOWTYPE\":\"1\",\n      \"PSTLVL\":\"\",\n      \"RELINFTYPE\":\"1\",\n      \"SIGNCODE\":\"\",\n      \"OPRNM\":\"\",\n      \"OPRPYNM\":\"\",\n      \"OPRIDTYPE\":\"\",\n      \"OPRIDNO\":\"\",\n      \"OPRMOBILE\":\"\",\n      \"OPRTEL\":\"\"\n  \n    }\n  ], \n  \"FILELIST\": [\n    {\n      \"FILETYPE\":\"0\",\n      \"FILEDATA\":\"iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw-eHBhY2tldCBiZWdpbj0i77u-IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+I\"\n    },\n    {\n      \"FILETYPE\":\"1\",\n      \"FILEDATA\":\"iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw-eHBhY2tldCBiZWdpbj0i77u-IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+I\"\n    }\n  ]\n}\n";
        json2 = "";
        json3 = "";
    }
}

