/*
 * Decompiled with CFR 0.152.
 */
package com.citic.openbank.sdk;

import com.citic.combpre.util.AESUtil;
import com.citic.openbank.configuration.OpenBankSdkConfiguration;
import com.citic.openbank.sdk.AppException;
import com.citic.openbank.sdk.CiticSdkInterface;
import com.citic.openbank.sdk.RequestHeader;
import com.citicbank.cbframework.common.exception.CBException;
import com.citicbank.cbframework.common.security.CBRSA;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiticSdk
implements CiticSdkInterface {
    private PrivateKey privateKeyDecrypt;
    private PrivateKey privateKeySignature;
    private PublicKey publicKeyEncrypt;
    private PublicKey publicKeyValidateSignature;
    private static String ENCODING = "utf8";
    private OpenBankSdkConfiguration configuration = new OpenBankSdkConfiguration();
    private static Logger logger = LoggerFactory.getLogger(CiticSdk.class);
    private static HttpClient httpClient = null;

    public static CiticSdkInterface getInstance() {
        return new CiticSdk();
    }

    private void checkConfiguration() {
        if (this.configuration.getOpenBusiType() == null || "".equals(this.configuration.getOpenBusiType())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_busi_type \u53d8\u91cf");
        }
        if (this.configuration.getOpenVer() == null || "".equals(this.configuration.getOpenVer())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_ver \u53d8\u91cf");
        }
        if (this.configuration.getOpenMerCode() == null || "".equals(this.configuration.getOpenMerCode())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_mer_code \u53d8\u91cf");
        }
        if (this.configuration.getOpenMerName() == null || "".equals(this.configuration.getOpenMerName())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_mer_name \u53d8\u91cf");
        }
        if (this.configuration.getPublicUrl() == null || "".equals(this.configuration.getPublicUrl())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e public_url \u53d8\u91cf");
        }
        if (this.configuration.getTransferEncode() == null || "".equals(this.configuration.getTransferEncode())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e transfer_encode \u53d8\u91cf");
        }
        if (this.configuration.getConnectionTimeout() == -1) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e open_mer_name \u53d8\u91cf");
        }
    }

    public PrivateKey getPrivateKeyDecrypt() {
        return this.privateKeyDecrypt;
    }

    @Override
    public void setOpenVer(String openVer) {
        this.configuration.setOpenVer(openVer);
    }

    @Override
    public void setOpenMerCode(String openMerCode) {
        this.configuration.setOpenMerCode(openMerCode);
    }

    @Override
    public void setOpenMerName(String openMerName) {
        this.configuration.setOpenMerName(openMerName);
    }

    @Override
    public void setOpenBusiType(String openBusiType) {
        this.configuration.setOpenBusiType(openBusiType);
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.configuration.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public void setPublicUrl(String publicUrl) {
        this.configuration.setPublicUrl(publicUrl);
    }

    @Override
    public void setTransferEncode(String code) {
        this.configuration.setTransferEncode(code);
    }

    private PrivateKey generatePrivKeyFromBytes(byte[] enc_key, byte[] pwd) {
        char[] keyPassword = null;
        try {
            keyPassword = new String(pwd, "UTF-8").toCharArray();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        PrivateKey privateKey = null;
        try {
            privateKey = CryptUtil.decryptPrivateKey(enc_key, keyPassword);
        }
        catch (AppException e) {
            e.printStackTrace();
        }
        return privateKey;
    }

    @Override
    public void setPrivateKeyDecryptWithPwd(byte[] enc_key, byte[] pwd) {
        PrivateKey key = this.generatePrivKeyFromBytes(enc_key, pwd);
        if (key == null) {
            logger.error("\u8bbe\u7f6e privateKeyDecrypt \u5931\u8d25, \u624b\u5de5\u4fee\u6539\u5bc6\u94a5\u6587\u4ef6\u53ef\u80fd\u5bfc\u81f4\u8fd9\u79cd\u5931\u8d25");
            throw new RuntimeException("\u8bbe\u7f6e privateKeyDecrypt \u5931\u8d25");
        }
        this.privateKeyDecrypt = key;
    }

    public PrivateKey getPrivateKeySignature() {
        return this.privateKeySignature;
    }

    @Override
    public void setPrivateKeySignatureWithPwd(byte[] enc_key, byte[] pwd) {
        PrivateKey key = this.generatePrivKeyFromBytes(enc_key, pwd);
        if (key == null) {
            logger.error("\u8bbe\u7f6e privateKeySignature \u5931\u8d25, \u624b\u5de5\u4fee\u6539\u5bc6\u94a5\u6587\u4ef6\u53ef\u80fd\u5bfc\u81f4\u8fd9\u79cd\u5931\u8d25");
            throw new RuntimeException("\u8bbe\u7f6e privateKeySignature \u5931\u8d25");
        }
        this.privateKeySignature = key;
    }

    @Override
    public void setPrivateKeyDecryptWithPwdUseStr(String base64KeyStr, String pwdStr) {
        try {
            this.setPrivateKeyDecryptWithPwd(Base64.decode(base64KeyStr.getBytes("UTF-8")), pwdStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPrivateKeySignatureWithPwdUseStr(String base64KeyStr, String pwdStr) {
        try {
            this.setPrivateKeySignatureWithPwd(Base64.decode(base64KeyStr.getBytes("UTF-8")), pwdStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public PublicKey getPublicKeyEncrypt() {
        return this.publicKeyEncrypt;
    }

    @Override
    public void setPublicKeyEncrypt(byte[] key) {
        PublicKey pubKey = this.generatePubKeyFromBytes(key);
        if (pubKey == null) {
            logger.error("\u8bbe\u7f6e publicKeyEncrypt \u5931\u8d25, \u624b\u5de5\u4fee\u6539\u5bc6\u94a5\u6587\u4ef6\u53ef\u80fd\u5bfc\u81f4\u8fd9\u79cd\u5931\u8d25");
            throw new RuntimeException("\u8bbe\u7f6e publicKeyEncrypt \u5931\u8d25");
        }
        this.publicKeyEncrypt = pubKey;
    }

    public PublicKey getPublicKeyValidateSignature() {
        return this.publicKeyValidateSignature;
    }

    @Override
    public void setPublicKeyValidateSignature(byte[] key) {
        PublicKey pubKey = this.generatePubKeyFromBytes(key);
        if (pubKey == null) {
            logger.error("\u8bbe\u7f6e publicKeyValidateSignature \u5931\u8d25, \u624b\u5de5\u4fee\u6539\u5bc6\u94a5\u6587\u4ef6\u53ef\u80fd\u5bfc\u81f4\u8fd9\u79cd\u5931\u8d25");
            throw new RuntimeException("\u8bbe\u7f6e publicKeyValidateSignature \u5931\u8d25");
        }
        this.publicKeyValidateSignature = pubKey;
    }

    @Override
    public void setPublicKeyEncryptUseStr(String base64Key) {
        try {
            this.setPublicKeyEncrypt(Base64.decode(base64Key.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPublicKeyValidateSignatureUseStr(String base64Key) {
        try {
            this.setPublicKeyValidateSignature(Base64.decode(base64Key.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private PublicKey generatePubKeyFromBytes(byte[] key) {
        X509Certificate cert = null;
        try {
            cert = CryptUtil.generateX509Certificate(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cert.getPublicKey();
    }

    protected static HttpClient getHttpClient() throws KeyManagementException, NoSuchAlgorithmException {
        if (httpClient != null) {
            return httpClient;
        }
        SSLContext sslContext = SSLContexts.custom().build();
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        return httpClient;
    }

    protected String buildReqJson(RequestHeader header, String reqBody) throws Exception {
        if (header.getOpenMerFlowId() == null || "".equals(header.getOpenMerFlowId())) {
            throw new IllegalArgumentException("\u5546\u6237\u6d41\u6c34\u53f7\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (header.getOpenTransCode() == null || "".equals(header.getOpenTransCode())) {
            throw new IllegalArgumentException("\u4ea4\u6613\u7801\u4e0d\u5f97\u4e3a\u7a7a");
        }
        String reqFormat = "{\n \"OPENVER\": \"%s\",\n \"OPENTRANSCODE\": \"%s\",\n \"OPENMERCODE\": \"%s\",\n \"OPENMERNAME\": \"%s\",\n \"OPENBUSITYPE\": \"%s\",\n \"OPENLAUNCHDATE\": \"%s\",\n \"OPENLAUNCHTIME\": \"%s\",\n \"OPENMERFLOWID\": \"%s\",\n \"txCode\": \"%s\",\n %s\n}\n";
        if (reqBody == null || "".equals(reqBody.trim()) || "{}".equals(reqBody.trim())) {
            reqBody = "{\"__blank_body__\": \"\"}";
        }
        reqBody = reqBody.substring(reqBody.indexOf(123) + 1, reqBody.lastIndexOf(125));
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat HHmmss = new SimpleDateFormat("HHmmss");
        String reqJson = String.format(reqFormat, header.getOpenVer() == null ? this.configuration.getOpenVer() : header.getOpenVer(), header.getOpenTransCode(), header.getOpenMerCode() == null ? this.configuration.getOpenMerCode() : header.getOpenMerCode(), header.getOpenMerName() == null ? this.configuration.getOpenMerName() : header.getOpenMerName(), header.getOpenBusiType() == null ? this.configuration.getOpenBusiType() : header.getOpenBusiType(), header.getOpenLaunchDate() == null ? yyyyMMdd.format(new Date()) : header.getOpenLaunchDate(), header.getOpenLaunchTime() == null ? HHmmss.format(new Date()) : header.getOpenLaunchTime(), header.getOpenMerFlowId(), header.getOpenTransCode(), reqBody);
        logger.debug("\u8bf7\u6c42\u62a5\u6587\u660e\u6587: " + reqJson);
        String encryptBusiness = null;
        String signData = null;
        signData = this.signature(reqJson);
        encryptBusiness = this.encryptBusiness(reqJson);
        JSONObject jsonObject = JSONObject.fromObject((Object)"{}");
        jsonObject.put((Object)"encryptBody", (Object)encryptBusiness);
        jsonObject.put((Object)"sign", (Object)signData);
        return jsonObject.toString();
    }

    private Boolean verifySign1(byte[] msg, String signData) throws Exception {
        PublicKey signpublicKey = this.getPublicKeyValidateSignature();
        if (signpublicKey == null) {
            logger.error("\u9a8c\u7b7e\u516c\u94a5\u4e3a\u7a7a");
            return false;
        }
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initVerify(signpublicKey);
        signature.update(msg);
        return signature.verify(Base64.decode(signData.getBytes("utf8")));
    }

    protected String verifySignBusiness(String business, String signStr) throws AppException {
        JSONObject jsonObject = JSONObject.fromObject((Object)business);
        String signData = null;
        signData = "".equals(signStr) || signStr == null ? (String)jsonObject.remove("signData") : signStr;
        if (signData == null) {
            logger.error("signData is null");
            throw new AppException("IF01036");
        }
        signData = signData.replace("\r|\n", "");
        StringBuffer sbf = CiticSdk.formaturlMap(jsonObject);
        business = sbf.toString().replaceAll("\\}\\{", "\\},\\{").replaceAll("\r|\n", "");
        boolean boo = false;
        String encode = this.configuration.getTransferEncode();
        try {
            boo = this.verifySign1(business.getBytes(encode), signData);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new AppException("IF01001", e);
        }
        if (boo) {
            return business;
        }
        throw new AppException("IF01001");
    }

    protected static StringBuffer formaturlMap(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        StringBuffer plain = new StringBuffer();
        ArrayList infolds = new ArrayList(jsonObject.entrySet());
        Collections.sort(infolds, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        plain.append("{");
        for (Map.Entry item : infolds) {
            String key = (String)item.getKey();
            if ("commonDataList".equalsIgnoreCase(key)) continue;
            plain.append("\"" + key + "\"");
            plain.append(":");
            Object val = item.getValue();
            if (val instanceof JSONObject) {
                StringBuffer str = CiticSdk.formaturlMap((JSONObject)val);
                plain.append(str);
            } else if (val instanceof String) {
                plain.append("\"" + val + "\"");
            } else if (val instanceof JSONArray) {
                plain.append("[");
                JSONArray arr = (JSONArray)val;
                for (int i = 0; i < arr.size(); ++i) {
                    StringBuffer tempstr = new StringBuffer();
                    Object obj = arr.get(i);
                    if (obj instanceof JSONObject) {
                        tempstr = CiticSdk.formaturlMap((JSONObject)obj);
                    }
                    plain.append(tempstr);
                }
                plain.append("]");
            }
            plain.append(",");
        }
        plain.delete(plain.length() - 1, plain.length());
        if (plain.length() > 0) {
            plain.append("}");
        }
        return plain;
    }

    @Override
    public String signature(String input) throws AppException {
        try {
            String data = input.replace("\r|\n", "");
            JSONObject jsonObject = JSONObject.fromObject((Object)data);
            StringBuffer sbf = CiticSdk.formaturlMap(jsonObject);
            String reSbf = sbf.toString().replaceAll("\\}\\{", "\\},\\{");
            byte[] msg = reSbf.getBytes(ENCODING);
            PrivateKey privateKey = this.getPrivateKeySignature();
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(privateKey);
            signature.update(msg);
            byte[] bytarr = signature.sign();
            String signData = new String(Base64.encode(bytarr), ENCODING);
            signData = signData.replace("\r|\n", "");
            return signData;
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5931\u8d25: " + e.getStackTrace(), (Throwable)e);
            throw new AppException("IF01002", e);
        }
    }

    @Override
    public String decryptDataFromBusiness(String encryptBusinessData) throws AppException {
        String decryptedBusinessData = null;
        String[] encryptBusinessDataArr = encryptBusinessData.split("@@");
        String encryptKey = encryptBusinessDataArr[1];
        try {
            RSAPrivateKey privateKey = (RSAPrivateKey)this.getPrivateKeyDecrypt();
            byte[] keyByte = CBRSA.decrypt((RSAKey)privateKey, (byte[])Base64.decode(encryptKey.getBytes("UTF-8")));
            String encryptKeystr = new String(keyByte, "UTF-8");
            byte[] decryptedBusinessDataBytes = AESUtil.decrypt(Base64.decode(encryptBusinessDataArr[0].getBytes("UTF-8")), encryptKeystr);
            decryptedBusinessData = new String(decryptedBusinessDataBytes, ENCODING);
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u62a5\u6587\u5f02\u5e38", (Throwable)e);
            throw new AppException("IF01017", e);
        }
        return decryptedBusinessData;
    }

    @Override
    public String remoteCall(RequestHeader header, String reqBody) throws AppException {
        this.checkConfiguration();
        String encode = this.configuration.getTransferEncode();
        String reqJson = null;
        try {
            reqJson = this.buildReqJson(header, reqBody);
            logger.debug("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587: " + reqJson);
        }
        catch (Exception e) {
            logger.error("build ReqJson error", (Throwable)e);
            throw new AppException("IF01001", e);
        }
        HttpClient httpClient = null;
        try {
            httpClient = CiticSdk.getHttpClient();
        }
        catch (KeyManagementException e) {
            logger.error("get httpclient error", (Throwable)e);
            throw new AppException("IF01002", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("get httpclient error", (Throwable)e);
            throw new AppException("IF01003", e);
        }
        String url = this.configuration.getPublicUrl();
        HttpPost httpPost = new HttpPost(url);
        StringEntity se = null;
        try {
            se = new StringEntity(reqJson);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("unsupport encoding ", (Throwable)e);
            throw new AppException("IF01004", e);
        }
        se.setContentType("text/json");
        se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
        httpPost.setEntity((HttpEntity)se);
        HttpResponse resp = null;
        try {
            resp = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            logger.error("httpclient execute error ", (Throwable)e);
            throw new AppException("IF01005", e);
        }
        String respJson = null;
        try {
            respJson = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)encode);
        }
        catch (IOException e) {
            logger.error("encoding response error  ", (Throwable)e);
            throw new AppException("IF01006", e);
        }
        logger.debug("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587: " + respJson);
        String realRespJson = null;
        realRespJson = this.validateSignature(respJson);
        if (realRespJson == null) {
            logger.error("\u9a8c\u7b7e\u5931\u8d25!!");
            return null;
        }
        logger.debug("\u54cd\u5e94\u62a5\u6587\u660e\u6587: " + realRespJson);
        return realRespJson;
    }

    @Override
    public String validateSignature(String input) throws AppException {
        JSONObject jsonObject = JSONObject.fromObject((Object)input);
        String encryptBusinessData = jsonObject.getString("encryptBody");
        if (encryptBusinessData == null || "".equals(encryptBusinessData)) {
            return null;
        }
        String signStr = jsonObject.getString("sign");
        String decryptedBusinessData = null;
        try {
            decryptedBusinessData = this.decryptDataFromBusiness(encryptBusinessData);
        }
        catch (AppException e1) {
            e1.printStackTrace();
            return null;
        }
        try {
            decryptedBusinessData = this.verifySignBusiness(decryptedBusinessData, signStr);
        }
        catch (AppException e) {
            logger.error("\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("\u9a8c\u7b7e\u5931\u8d25: ", (Throwable)e);
            throw new AppException("IF01007", e);
        }
        return decryptedBusinessData;
    }

    @Override
    public String encryptBusiness(String data) throws AppException {
        String encryptKey = AESUtil.getRandomAESKey();
        byte[] encryptBusinessDataByte = AESUtil.encrypt(data, encryptKey);
        String encryptBusiness = null;
        try {
            encryptBusiness = new String(Base64.encode(encryptBusinessDataByte), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException();
        }
        PublicKey publicKey = this.getPublicKeyEncrypt();
        if (publicKey == null) {
            encryptBusiness = data;
        } else {
            byte[] encryptKeyByte = new byte[]{};
            try {
                encryptKeyByte = CBRSA.encrypt((RSAKey)((RSAKey)((Object)publicKey)), (byte[])encryptKey.getBytes("UTF-8"));
            }
            catch (CBException e) {
                logger.error("CBException", (Throwable)e);
                throw new AppException("IF01008", (Exception)((Object)e));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("UnsupportedEncodingException", (Throwable)e);
                throw new IllegalArgumentException();
            }
            String encryptKeyString = null;
            try {
                encryptKeyString = new String(Base64.encode(encryptKeyByte), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException();
            }
            encryptBusiness = encryptBusiness + "@@" + encryptKeyString;
        }
        return encryptBusiness;
    }
}

