/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    public static byte[] getBytesFromFile(String filePath) throws Exception {
        FileInputStream is = new FileInputStream(filePath);
        return FileUtil.getBytesFromFile(is);
    }

    public static byte[] getBytesFromFile(InputStream inputStream) throws Exception {
        byte[] keyhex = null;
        BufferedInputStream keystream = null;
        try {
            keystream = new BufferedInputStream(inputStream);
            int len = keystream.available();
            if (len > 0x3700000) {
                throw new IOException("file is too big!");
            }
            keyhex = new byte[len];
            keystream.read(keyhex, 0, len);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (keystream != null) {
                keystream.close();
            }
        }
        return keyhex;
    }

    public static void writeBytesToFile(byte[] sourceData, String filePath) throws IOException {
        FileOutputStream keystream = null;
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            keystream = new FileOutputStream(filePath);
            keystream.write(sourceData);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (keystream != null) {
                keystream.close();
            }
        }
    }

    public static void writeBytesToFile(byte[] data, int offSet, int len, OutputStream os) throws IOException {
        if (os != null) {
            os.write(data, offSet, len);
        }
    }
}

