/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.util;

import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;

public class HashEncoderUtil {
    public static byte[] derEncoder(String signAlg, byte[] hash) throws PKIException {
        try {
            AlgorithmIdentifier digestAlgIdentifier = null;
            if (signAlg.equals("MD5") || signAlg.equals("md5WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, DERNull.INSTANCE);
            } else if (signAlg.equals("SHA-1") || signAlg.equals("sha1WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, DERNull.INSTANCE);
            } else if (signAlg.equals("SHA-256") || signAlg.equals("sha256WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, DERNull.INSTANCE);
            } else if (signAlg.equals("SHA-512") || signAlg.equals("sha512WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, DERNull.INSTANCE);
            } else {
                if (signAlg.equals("SM3") || signAlg.equals("sm3WithSM2Encryption")) {
                    return hash;
                }
                throw new PKIException(PKIException.DIGEST, PKIException.DIGEST_DES + " " + PKIException.NOT_SUP_DES + " " + signAlg);
            }
            DigestInfo dInfo = new DigestInfo(digestAlgIdentifier, hash);
            return dInfo.getEncoded("DER");
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }
}

