/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.util;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2Crypto;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.lib.crypto.jni.JNISymAlg;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import java.security.Key;
import java.security.SecureRandom;

public class SM2AndItsCloseSymAlgUtil {
    private static int SM4_BLOCK_SIZE = 16;

    public static byte[] generateSecretKey() {
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[16];
        random.nextBytes(key);
        return key;
    }

    public static byte[] generateIV() {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    public static byte[] crypto(boolean useJNI, boolean forEncryption, byte[] key, byte[] sourceData, Mechanism algName) throws Exception {
        if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            return SM2AndItsCloseSymAlgUtil.useSM4CBCEncrypt(useJNI, forEncryption, key, sourceData, param.getIv());
        }
        if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            return SM2AndItsCloseSymAlgUtil.useSM4ECBEncrypt(useJNI, forEncryption, key, sourceData);
        }
        throw new Exception("can not support this algorithm to crypto:" + algName.getMechanismType());
    }

    private static byte[] useSM4CBCEncrypt(boolean useJNI, boolean forEncryption, byte[] key, byte[] input, byte[] iv) throws Exception {
        if (useJNI) {
            JNISymAlg jni = new JNISymAlg();
            if (forEncryption) {
                jni.encryptInit(JNISymAlg.NID_ChinaSM4_CBC, key, iv);
                byte[] cipher = new byte[input.length + (SM4_BLOCK_SIZE - input.length % SM4_BLOCK_SIZE)];
                int len1 = jni.encryptProcess(input, 0, input.length, cipher, 0);
                jni.encryptFinal(cipher, len1);
                return cipher;
            }
            jni.decryptInit(JNISymAlg.NID_ChinaSM4_CBC, key, iv);
            byte[] plainText = new byte[input.length];
            int len1 = jni.decryptProcess(input, 0, input.length, plainText, 0);
            int len2 = jni.decryptFinal(plainText, len1);
            int total = len1 + len2;
            byte[] out2 = new byte[total];
            System.arraycopy(plainText, 0, out2, 0, total);
            return out2;
        }
        PaddedBufferedBlockCipher cipher = null;
        cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
        ParametersWithIV param = new ParametersWithIV(new KeyParameter(key), iv);
        cipher.init(forEncryption, param);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    private static byte[] useSM4ECBEncrypt(boolean useJNI, boolean forEncryption, byte[] key, byte[] input) throws Exception {
        PaddedBufferedBlockCipher cipher = null;
        cipher = new PaddedBufferedBlockCipher(new SM4Engine(), new PKCS7Padding());
        KeyParameter params = new KeyParameter(key);
        cipher.init(forEncryption, params);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    public static byte[] sm2Encrypt(boolean isEncrypted, Key sm2Key, byte[] input) throws Exception {
        SM2Crypto crypto = new SM2Crypto();
        if (isEncrypted) {
            SM2PublicKey pubKey = (SM2PublicKey)sm2Key;
            crypto.initEncrypt(pubKey.getQ());
            return crypto.encrypt(input);
        }
        SM2PrivateKey priKey = (SM2PrivateKey)sm2Key;
        crypto.initDecrypt(priKey.getDByInt());
        return crypto.decrypt(input);
    }

    public static byte[] sm2EncryptByJNI(boolean isEncrypted, Key sm2Key, byte[] input) throws Exception {
        if (isEncrypted) {
            byte[] encryptedData = new byte[input.length + 96];
            SM2PublicKey pubKey = (SM2PublicKey)sm2Key;
            byte[] pubX = BigIntegerUtil.asUnsigned32ByteArray(pubKey.getPubXByInt());
            byte[] pubY = BigIntegerUtil.asUnsigned32ByteArray(pubKey.getPubYByInt());
            JNISM2.encrypt(input, pubX, pubY, encryptedData);
            return encryptedData;
        }
        byte[] plainText = new byte[input.length - 96];
        SM2PrivateKey priKey = (SM2PrivateKey)sm2Key;
        byte[] da = BigIntegerUtil.asUnsigned32ByteArray(priKey.getDByInt());
        JNISM2.decrypt(input, da, plainText);
        return plainText;
    }

    public static byte[] sm2EncryptMessage(boolean isEncrypted, Key sm2Key, byte[] input) throws Exception {
        SM2Crypto crypto = new SM2Crypto();
        if (isEncrypted) {
            SM2PublicKey pubKey = (SM2PublicKey)sm2Key;
            crypto.initEncrypt(pubKey.getQ());
            return crypto.encryptMessage(input);
        }
        SM2PrivateKey priKey = (SM2PrivateKey)sm2Key;
        crypto.initDecrypt(priKey.getDByInt());
        return crypto.decryptMessage(input);
    }
}

