/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.jcajce.asymmetric.keypair;

import cfca.sadk.algorithm.sm2.SM2Param;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;

public class SM2KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int keysize;

    public SM2KeyPairGenerator() {
        this.initialize(256, null);
    }

    public void initialize(int keysize, SecureRandom random) {
        if (256 != keysize) {
            throw new InvalidParameterException("SM2 keysize must be 256 bytes!");
        }
        this.keysize = keysize;
    }

    public KeyPair generateKeyPair() {
        int bitY;
        int bitX;
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(SM2Param.ecc_bc_spec, new SecureRandom());
        ECKeyPairGenerator ecc_key_pair_generator = new ECKeyPairGenerator();
        ecc_key_pair_generator.init(ecc_ecgenparam);
        AsymmetricCipherKeyPair pair = null;
        ECPublicKeyParameters pub = null;
        do {
            pair = ecc_key_pair_generator.generateKeyPair();
            pub = (ECPublicKeyParameters)pair.getPublic();
            bitX = pub.getQ().getX().toBigInteger().bitLength();
            bitY = pub.getQ().getY().toBigInteger().bitLength();
        } while (bitX < 249 || bitY < 249);
        ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
        SM2PublicKey pubKey = new SM2PublicKey(pub);
        SM2PrivateKey priKey = new SM2PrivateKey(priv);
        priKey.setSM2PublicKey(pubKey);
        return new KeyPair(pubKey, priKey);
    }
}

