/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.jcajce.signature;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2HashZValue;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM2Result;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.jcajce.signature.AlgorithmParameterImpl;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftSM2;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.x509.certificate.X509Cert;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class SM2SignatureImpl
extends SignatureSpi {
    protected ASN1ObjectIdentifier OID;
    protected MessageDigest md;
    protected boolean mdReset;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected byte[] digestData;

    public SM2SignatureImpl(String digestAlgorithm, ASN1ObjectIdentifier OID) {
        this.OID = OID;
        try {
            this.md = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException localNoSuchAlgorithmException) {
            throw new ProviderException(localNoSuchAlgorithmException.getMessage());
        }
        this.mdReset = true;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
    }

    protected void engineUpdate(byte b) throws SignatureException {
    }

    protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] sign = new byte[64];
        if (this.digestData == null || this.digestData.length != 32) {
            throw new InvalidParameterException("the digest data is null or not 32 bytes!");
        }
        SM2PrivateKey key = null;
        if (!(this.privateKey instanceof SM2PrivateKey)) {
            throw new InvalidParameterException("The private key type is not sm2 type!");
        }
        key = (SM2PrivateKey)this.privateKey;
        BCSoftSM2 bcSoftSM2 = new BCSoftSM2();
        SM2Result sm2Ret = new SM2Result();
        bcSoftSM2.sign(this.digestData, key.getDByInt(), sm2Ret);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.r), 0, sign, 0, 32);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.s), 0, sign, 32, 32);
        return sign;
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        SM2PublicKey key = null;
        if (!(this.publicKey instanceof SM2PublicKey)) {
            throw new InvalidParameterException("the key type is not SM2 public key");
        }
        key = (SM2PublicKey)this.publicKey;
        if (this.digestData == null || this.digestData.length != 32) {
            throw new InvalidParameterException("the digest data is null or not 32 bytes!");
        }
        if (sigBytes == null || sigBytes.length != 64) {
            throw new InvalidParameterException("the signature data is null or not 64 bytes!");
        }
        System.arraycopy(sigBytes, 0, r, 0, 32);
        System.arraycopy(sigBytes, 32, s, 0, 32);
        BCSoftSM2 sm2 = new BCSoftSM2();
        SM2Result sm2Ret = new SM2Result();
        sm2Ret.r = new BigInteger(1, r);
        sm2Ret.s = new BigInteger(1, s);
        return sm2.verify(this.digestData, key.getQ(), sm2Ret);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super.engineSetParameter(params);
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    public static class SM3withSM2inPKCS7Wrapping
    extends SM3withSM2 {
        protected AlgorithmParameterImpl algParamImpl;
        protected boolean hasSourceData;
        protected byte[] sourceData;
        protected static Session session = null;

        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.algParamImpl = (AlgorithmParameterImpl)params;
            Boolean tmphasSource = (Boolean)this.algParamImpl.algParamImpl[0];
            this.hasSourceData = tmphasSource;
            super.engineSetParameter(this.algParamImpl);
        }

        protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
            this.sourceData = (byte[])input.clone();
            super.engineUpdate(input, off, len);
        }

        protected byte[] engineSign() throws SignatureException {
            byte[] signedData = super.engineSign();
            X509Cert[] certs = new X509Cert[]{this.x509Cert};
            Mechanism mechanism = new Mechanism("sm3WithSM2Encryption");
            byte[] p7SignedData = null;
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                p7SignedData = p7.packageSignedData(this.hasSourceData, null, this.sourceData, signedData, mechanism, certs);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return p7SignedData;
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            SM2ContextConfig.setUseZValue(this.hasZValue);
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                p7.loadDERData(sigBytes);
                if (this.hasSourceData) {
                    return p7.verifyP7SignedDataAttach();
                }
                return p7.verifyP7SignedData(this.sourceData);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
            catch (Exception e) {
                throw new SignatureException(e.getMessage());
            }
        }

        static {
            try {
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class SM3withSM2
    extends SM2SignatureImpl {
        protected AlgorithmParameterImpl algParamImpl;
        protected X509Cert x509Cert;
        protected boolean hasZValue;

        public SM3withSM2() {
            super("SM3", PKCSObjectIdentifiers.sm3);
        }

        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.algParamImpl = (AlgorithmParameterImpl)params;
            this.x509Cert = (X509Cert)this.algParamImpl.algParamImpl[1];
            Boolean tmpIsZValue = (Boolean)this.algParamImpl.algParamImpl[2];
            this.hasZValue = tmpIsZValue;
        }

        protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
            if (this.hasZValue) {
                try {
                    PublicKey publicKey = this.x509Cert.getPublicKey();
                    SM2PublicKey sm2PublicKey = (SM2PublicKey)publicKey;
                    BigInteger pubX = sm2PublicKey.getPubXByInt();
                    BigInteger pubY = sm2PublicKey.getPubYByInt();
                    byte[] z = SM2HashZValue.getZa(pubX, pubY, null);
                    this.md.update(z, 0, z.length);
                    this.md.update(input, off, len);
                    this.digestData = this.md.digest();
                }
                catch (PKIException e) {
                    throw new SignatureException(e.getMessage());
                }
            } else {
                this.md.update(input, off, len);
                this.digestData = this.md.digest();
            }
        }
    }
}

