/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.bcsoft;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2Param;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigFileCipherUtil;
import cfca.sadk.algorithm.util.HashEncoderUtil;
import cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import cfca.sadk.algorithm.util.SM2AndItsCloseSymAlgUtil;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;

public class BCSoftLib
implements Session {
    public KeyPair generateKeyPair(Mechanism keyType, int keyLength) throws PKIException {
        try {
            if (keyType.getMechanismType().equals("SM2")) {
                int bitY;
                int bitX;
                ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(SM2Param.ecc_bc_spec, new SecureRandom());
                ECKeyPairGenerator ecc_key_pair_generator = new ECKeyPairGenerator();
                ecc_key_pair_generator.init(ecc_ecgenparam);
                AsymmetricCipherKeyPair pair = null;
                ECPublicKeyParameters pub = null;
                do {
                    pair = ecc_key_pair_generator.generateKeyPair();
                    pub = (ECPublicKeyParameters)pair.getPublic();
                    bitX = pub.getQ().getX().toBigInteger().bitLength();
                    bitY = pub.getQ().getY().toBigInteger().bitLength();
                } while (bitX < 249 || bitY < 249);
                ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
                SM2PublicKey pubKey = new SM2PublicKey(pub);
                SM2PrivateKey priKey = new SM2PrivateKey(priv);
                priKey.setSM2PublicKey(pubKey);
                return new KeyPair(pubKey, priKey);
            }
            if (keyType.getMechanismType().equals("RSA")) {
                KeyPairGenerator keyPairGen = null;
                try {
                    keyPairGen = KeyPairGenerator.getInstance("RSA");
                }
                catch (Exception e) {
                    return null;
                }
                if (keyLength <= 0 || keyLength > 4096) {
                    throw new PKIException("key length is illgal:" + keyLength);
                }
                keyPairGen.initialize(keyLength);
                KeyPair keyPair = keyPairGen.generateKeyPair();
                return keyPair;
            }
            throw new PKIException(PKIException.BC_KEY_PAIR, PKIException.BC_KEY_PAIR_DES + " " + PKIException.NOT_SUP_DES + keyType.getMechanismType());
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public byte[] sign(Mechanism mechanim, PrivateKey priKey, byte[] sourceData) throws PKIException {
        String signAlg = mechanim.getMechanismType();
        if (!(signAlg.equals("md5WithRSAEncryption") || signAlg.equals("sha1WithRSAEncryption") || signAlg.equals("sha256WithRSAEncryption") || signAlg.equals("sha512WithRSAEncryption") || signAlg.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + signAlg);
        }
        if (sourceData == null) {
            throw new PKIException("the source data is null!");
        }
        try {
            if (signAlg.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                byte[] out = null;
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    out = HashUtil.SM2HashMessageByBCWithZValue(null, sourceData, sm2PubKey.getQ().getX().toBigInteger(), sm2PubKey.getQ().getY().toBigInteger());
                } else {
                    out = HashUtil.SM2HashMessageByBCWithoutZValue(sourceData);
                }
                return SM2PackageUtil.encryptByBC(out, sm2priKey);
            }
            byte[] out = HashUtil.RSAHashMessageByBC(sourceData, mechanim, true);
            return RSAPackageUtil.encrypt(out, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                byte[] out = null;
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    out = HashUtil.SM2HashFileByBCWithZValue(null, sourceStream, sm2PubKey.getQ().getX().toBigInteger(), sm2PubKey.getQ().getY().toBigInteger());
                } else {
                    out = HashUtil.SM2HashFileByBCWithoutZValue(sourceStream);
                }
                return SM2PackageUtil.encryptByBC(out, sm2priKey);
            }
            byte[] digestData = HashUtil.RSAHashFileByBC(sourceStream, mechanism, true);
            return RSAPackageUtil.encrypt(digestData, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                byte[] out = null;
                out = SM2ContextConfig.getUseZValue() ? HashUtil.SM2HashMessageByBCWithZValue(null, sourceData, sm2PubKey.getQ().getX().toBigInteger(), sm2PubKey.getQ().getY().toBigInteger()) : HashUtil.SM2HashMessageByBCWithoutZValue(sourceData);
                return SM2PackageUtil.verifyByBC(out, signData, pubKey);
            }
            byte[] hashData = HashUtil.RSAHashMessageByBC(sourceData, mechanism, true);
            byte[] sig = RSAPackageUtil.decrypt(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                byte[] out = null;
                out = SM2ContextConfig.getUseZValue() ? HashUtil.SM2HashFileByBCWithZValue(null, sourceStream, sm2PubKey.getQ().getX().toBigInteger(), sm2PubKey.getQ().getY().toBigInteger()) : HashUtil.SM2HashFileByBCWithoutZValue(sourceStream);
                return SM2PackageUtil.verifyByBC(out, signData, pubKey);
            }
            byte[] hashData = HashUtil.RSAHashFileByBC(sourceStream, mechanism, true);
            byte[] sig = RSAPackageUtil.decrypt(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2Encrypt(true, key, sourceData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncrypt(true, key, sourceData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(false, true, key.getEncoded(), sourceData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(false, true, key.getEncoded(), sourceData, mechanism);
            }
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public byte[] encryptMessage(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2EncryptMessage(true, key, sourceData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncrypt(true, key, sourceData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(false, true, key.getEncoded(), sourceData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(false, true, key.getEncoded(), sourceData, mechanism);
            }
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2Encrypt(false, key, encryptData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncrypt(false, key, encryptData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(false, false, key.getEncoded(), encryptData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(false, false, key.getEncoded(), encryptData, mechanism);
            }
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public byte[] decryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2EncryptMessage(false, key, encryptData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncrypt(false, key, encryptData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(false, false, key.getEncoded(), encryptData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(false, false, key.getEncoded(), encryptData, mechanism);
            }
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public byte[] signByHash(Mechanism mechanim, PrivateKey priKey, byte[] digest) throws PKIException {
        String signAlg = mechanim.getMechanismType();
        if (!(signAlg.equals("md5WithRSAEncryption") || signAlg.equals("sha1WithRSAEncryption") || signAlg.equals("sha256WithRSAEncryption") || signAlg.equals("sha512WithRSAEncryption") || signAlg.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + signAlg);
        }
        if (digest == null) {
            throw new PKIException("the hash data is null!");
        }
        try {
            if (signAlg.equals("sm3WithSM2Encryption")) {
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                return SM2PackageUtil.encryptByBC(digest, sm2priKey);
            }
            byte[] derDigest = HashEncoderUtil.derEncoder(signAlg, digest);
            return RSAPackageUtil.encrypt(derDigest, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verifyByHash(Mechanism signAlg, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        String mType = signAlg.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                return SM2PackageUtil.verifyByBC(digest, signData, pubKey);
            }
            byte[] sig = RSAPackageUtil.decrypt(signData, pubKey);
            byte[] derDigest = HashEncoderUtil.derEncoder(mType, digest);
            return RSAPackageUtil.isRSAHashEqual(sig, derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public void encrypt(Mechanism encryptAlg, Key key, InputStream sourceStream, OutputStream encryptStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(true, encryptAlg, key.getEncoded(), sourceStream, encryptStream);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public void decrypt(Mechanism encryptAlg, Key key, InputStream encryptStream, OutputStream plainTextStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(false, encryptAlg, key.getEncoded(), encryptStream, plainTextStream);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public Key generateKey(Mechanism keyType) throws PKIException {
        String type = keyType.getMechanismType();
        SecureRandom random = new SecureRandom();
        if (type.equals("DESede")) {
            byte[] keyData = new byte[24];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("SM4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("RC4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        throw new PKIException("do not support this key type:" + type);
    }

    public Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        String type = keyType.getMechanismType();
        if ("DESede".equals(type)) {
            if (keyData.length != 24) {
                throw new PKIException("DES3 KEY must be 24 bytes");
            }
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if ("SM4".equals(type)) {
            if (keyData.length != 16) {
                throw new PKIException("SM4 KEY must be 16 bytes");
            }
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("RC4")) {
            if (keyData.length != 16) {
                throw new PKIException("RC4 KEY must be 16 bytes");
            }
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        throw new PKIException("do not support this key type:" + type);
    }

    public Provider getProvider() {
        return null;
    }

    public String getProviderName() {
        return null;
    }
}

